package com.moengage.inapp.model.meta;

import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Config {

  private static final String TAG = "Config";
  /**
   * Should the in-app be dismissed on back button press.
   */
  public final boolean isCancellable;

  public Config(boolean isCancellable) {
    this.isCancellable = isCancellable;
  }

  public static Config fromJson(JSONObject configJson){
    return new Config(configJson.optBoolean(CANCELLABLE, true));
  }

  public static JSONObject toJson(Config config) {
    try {
      JSONObject configJson = new JSONObject();
      configJson.put(CANCELLABLE, config.isCancellable);
      return configJson;
    } catch (Exception e) {
      Logger.e(TAG + " toJson() : ");
    }
    return null;
  }

  private static final String CANCELLABLE = "cancellable";

  @Override public String toString() {
    try {
      JSONObject jsonObject = toJson(this);
      if (jsonObject != null) {
        return jsonObject.toString(4);
      }
    } catch (JSONException e) {

    }
    return super.toString();
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Config config = (Config) o;

    return isCancellable == config.isCancellable;
  }
}