/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.model.meta;

import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class CampaignState {

  private static final String TAG = "CampaignState";
  /**
   * Number of times campaign is shown
   */
  public final long showCount;
  /**
   * Last time campaign was shown, time in epoch.
   */
  public final long lastShowTime;
  /**
   * Whether primary widget was clicked.
   */
  public final boolean isClicked;

  public CampaignState(long showCount, long lastShowTime, boolean isClicked) {
    this.showCount = showCount;
    this.lastShowTime = lastShowTime;
    this.isClicked = isClicked;
  }

  @Override public String toString() {
    try {
      JSONObject jsonObject = toJson(this);
      if (jsonObject != null) {
        return jsonObject.toString(4);
      }
    } catch (JSONException e) {

    }
    return super.toString();
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CampaignState that = (CampaignState) o;
    return showCount == that.showCount
        && lastShowTime == that.lastShowTime
        && isClicked == that.isClicked;
  }

  public static CampaignState fromJson(JSONObject stateJson){
    return new CampaignState(
        stateJson.optLong(SHOW_COUNT, 0),
        stateJson.optLong(LAST_SHOW_TIME, 0),
        stateJson.optBoolean(IS_CLICKED, false)
    );
  }

  public static JSONObject toJson(CampaignState campaignState){
    try {
      JSONObject stateJson = new JSONObject();
      stateJson.put(SHOW_COUNT, campaignState.showCount)
          .put(LAST_SHOW_TIME, campaignState.lastShowTime)
          .put(IS_CLICKED, campaignState.isClicked);
      return stateJson;
    } catch (JSONException e) {
      Logger.e( TAG + " toJson() : ", e);
    }
    return null;
  }

  private static final String SHOW_COUNT = "show_count";
  private static final String LAST_SHOW_TIME = "last_show_time";
  private static final String IS_CLICKED = "is_clicked";

}
