package com.moengage.inapp.model.enums;

/**
 * @author Umang Chamaria
 */
public enum ActionType {
  /**
   * Dismisses the in-app from the screen.
   */
  DISMISS,
  /**
   * Tracks an event or user attribute.
   */
  TRACK_DATA,
  /**
   * Navigate to activity/deep-link/url
   */
  NAVIGATE,
  /**
   * Share content with another app.
   */
  SHARE,
  /**
   * Copies text to the clipboard.
   */
  COPY_TEXT,
  /**
   * Call the given number.
   */
  CALL,
  /**
   * Send an SMS to a given number with the given content.
   */
  SMS,
  /**
   * Custom action to be executed by the app.
   */
  CUSTOM_ACTION,
  /**
   * Action for rating widget where actions can be performed based on rating value.
   */
  CONDITION_ACTION,
  /**
   * Action for taking input from the user.
   */
  USER_INPUT
}
