package com.moengage.inapp.model.actions;

import com.moengage.inapp.model.enums.ActionType;
import com.moengage.inapp.model.enums.UserInputType;
import java.util.List;

/**
 * @author Umang Chamaria
 * Date: 2019-10-04
 */
public class UserInputAction extends Action {

  public final UserInputType userInputType;
  public final int widgetId;
  public final List<Action> actionList;

  public UserInputAction(ActionType action,
      UserInputType userInputType, int widgetId,
      List<Action> actionList) {
    super(action);
    this.userInputType = userInputType;
    this.widgetId = widgetId;
    this.actionList = actionList;
  }

  @Override public String toString() {
    return "UserInputAction{" +
        "userInputType=" + userInputType +
        ", widgetId=" + widgetId +
        ", actionList=" + actionList +
        '}';
  }
}
