package com.moengage.inapp.model.actions;

import com.moengage.inapp.model.enums.ActionType;
import com.moengage.inapp.model.enums.DataTrackType;
import java.util.Map;

/**
 * @author Umang Chamaria
 * Date: 2019-07-16
 */
public class TrackAction extends Action{

  public final DataTrackType trackType;
  public final String value;
  public final String name;
  public final Map<String, Object> attributes;

  public TrackAction(ActionType action, DataTrackType trackType, String value, String name,
      Map<String, Object> attributes) {
    super(action);
    this.trackType = trackType;
    this.value = value;
    this.name = name;
    this.attributes = attributes;
  }

  @Override public String toString() {
    return "TrackAction{" +
        "trackType=" + trackType +
        ", value='" + value + '\'' +
        ", name='" + name + '\'' +
        ", attributes=" + attributes +
        '}';
  }
}
