package com.moengage.inapp.model.actions;

import androidx.annotation.Nullable;
import com.moengage.inapp.model.enums.NavigationType;
import com.moengage.inapp.model.enums.ActionType;
import java.util.Map;

/**
 * Navigation action object.
 *
 * @author Umang Chamaria
 * Date: 2019-07-16
 * @since 10.0.00
 */
public class NavigationAction extends Action {

  /**
   * Type of Navigation
   */
  public final NavigationType navigationType;
  /**
   * Key-Value pair added on the MoEngage Platform for navigation action.
   */
  @Nullable public final Map<String, Object> keyValuePairs;
  /**
   * Url/Screen-name to which the user should be navigated.
   */
  public final String navigationUrl;

  public NavigationAction(ActionType action,
      NavigationType navigationType, String navigationUrl,
      @Nullable Map<String, Object>keyValuePairs) {
    super(action);
    this.navigationType = navigationType;
    this.keyValuePairs = keyValuePairs;
    this.navigationUrl = navigationUrl;
  }

  @Override public String toString() {
    return "NavigationAction{" +
        "navigationType=" + navigationType +
        ", keyValuePairs=" + keyValuePairs +
        ", navigationUrl='" + navigationUrl + '\'' +
        '}';
  }
}
