package com.moengage.inapp.model.actions;

import androidx.annotation.Nullable;
import com.moengage.inapp.model.enums.ActionType;
import java.util.Map;

/**
 *
 *
 * @author Umang Chamaria
 * Date: 2019-07-16
 * @since 10.0.00
 */
public class CustomAction extends Action {
  /**
   * Key-Value Pair entered on the MoEngage Platform during campaign creation.
   */
  public final Map<String, Object> keyValuePairs;

  public CustomAction(ActionType action, @Nullable
      Map<String, Object> keyValuePairs) {
    super(action);
    this.keyValuePairs = keyValuePairs;
  }

  @Override public String toString() {
    return "{\n" +
        "keyValuePairs:" + keyValuePairs + "\n" +
        " actionType:" + actionType + "\n" +
        '}';
  }
}
