package com.moengage.inapp.model.actions;

import androidx.annotation.Nullable;
import com.moengage.inapp.model.enums.ActionType;

/**
 * @author Umang Chamaria
 * Date: 2019-07-16
 */
public class CopyAction extends Action {

  @Nullable public final String message;
  public final String textToCopy;

  public CopyAction(ActionType action,
      @Nullable String message,
      String textToCopy) {
    super(action);
    this.message = message;
    this.textToCopy = textToCopy;
  }

  @Override public String toString() {
    return "{\n" +
        "message:" + message + "\n" +
        " textToCopy:" + textToCopy + "\n" +
        " actionType:" + actionType + "\n" +
        '}';
  }
}
