package com.moengage.inapp.model;

import androidx.annotation.Nullable;

/**
 * @author Umang Chamaria
 * Date: 2019-10-15
 */
public class TestCampaignResponse {

  public final boolean isSuccess;
  @Nullable public final String errorMessage;
  @Nullable public final CampaignPayload campaignPayload;

  public TestCampaignResponse(boolean isSuccess,
      @Nullable CampaignPayload campaignPayload) {
    this(isSuccess, null, campaignPayload);
  }

  public TestCampaignResponse(boolean isSuccess, @Nullable String errorMessage) {
    this(isSuccess, errorMessage, null);
  }

  public TestCampaignResponse(boolean isSuccess) {
    this(isSuccess, null, null);
  }

  public TestCampaignResponse(boolean isSuccess, String errorMessage,
      CampaignPayload campaignPayload) {
    this.isSuccess = isSuccess;
    this.errorMessage = errorMessage;
    this.campaignPayload = campaignPayload;
  }
}
