package com.moengage.inapp.model;

/**
 * Self handled campaign object.
 *
 * @author Umang Chamaria
 * Date: 2019-08-05
 * @since 10.0.00
 */
public class SelfHandledCampaign {
  /**
   * Self handled campaign payload.
   */
  public final String payload;
  /**
   * Interval after which in-app should be dismissed, unit - Seconds
   */
  public final long dismissInterval;
  /**
   * Should the campaign be dismissed by pressing the back button or using the back gesture.
   * if the value is true campaign should be dismissed on back press.
   */
  public final boolean isCancellable;

  public SelfHandledCampaign(String payload, long dismissInterval, boolean isCancellable) {
    this.payload = payload;
    this.dismissInterval = dismissInterval;
    this.isCancellable = isCancellable;
  }

  @Override public String toString() {
    return "{\"SelfHandledCampaign\":{"
        + "\"payload\":\"" + payload + "\""
        + ", \"dismissInterval\":" + dismissInterval
        + ", \"isCancellable\":" + isCancellable
        + "}}";
  }
}
