package com.moengage.inapp.model;

/**
 * @author Umang Chamaria
 * Date: 2019-09-01
 */
public class Padding {
  public final double left;
  public final double right;
  public final double top;
  public final double bottom;

  public Padding(double left, double right, double top, double bottom) {
    this.left = left;
    this.right = right;
    this.top = top;
    this.bottom = bottom;
  }

  @Override public String toString() {
    return "{\"Padding\":{"
        + "\"left\":" + left
        + ", \"right\":" + right
        + ", \"top\":" + top
        + ", \"bottom\":" + bottom
        + "}}";
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Padding padding = (Padding) o;

    if (Double.compare(padding.left, left) != 0) return false;
    if (Double.compare(padding.right, right) != 0) return false;
    if (Double.compare(padding.top, top) != 0) return false;
    return Double.compare(padding.bottom, bottom) == 0;
  }
}
