package com.moengage.inapp.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.inapp.listeners.InAppMessageListener;
import com.moengage.inapp.model.actions.CustomAction;
import com.moengage.inapp.model.actions.NavigationAction;

/**
 * Provides InApp-Campaign related details in the listener {@link InAppMessageListener}
 *
 * @author Umang Chamaria
 * @since 10.0.00
 */
public class MoEInAppCampaign {

  /**
   * Campaign identifier.
   */
  @NonNull public final String campaignId;
  /**
   * Campaign Name specified during campaign creation.
   */
  @NonNull public final String campaignName;
  /**
   * Key value pairs for custom action defined on the SDK.
   */
  @Nullable public final CustomAction customAction;
  /**
   * Self handled campaign created on the MoEngage Platform.
   */
  @Nullable public final SelfHandledCampaign selfHandledCampaign;
  /**
   * Navigation
   */
  @Nullable public final NavigationAction navigationAction;

  public MoEInAppCampaign(@NonNull String campaignId, @NonNull String campaignName,
      @Nullable SelfHandledCampaign selfHandledCampaign) {
    this(campaignId, campaignName, null, selfHandledCampaign, null);
  }

  public MoEInAppCampaign(@NonNull String campaignId, @NonNull String campaignName,
      @Nullable NavigationAction navigationAction) {
    this(campaignId, campaignName, null, null, navigationAction);
  }

  public MoEInAppCampaign(@NonNull String campaignId, @NonNull String campaignName,
      @Nullable CustomAction customAction) {
    this(campaignId, campaignName, customAction, null, null);
  }

  public MoEInAppCampaign(@NonNull String campaignId, @NonNull String campaignName) {
    this(campaignId, campaignName, null, null, null);
  }

  public MoEInAppCampaign(@NonNull String campaignId, @NonNull String campaignName,
      @Nullable CustomAction customAction,
      @Nullable SelfHandledCampaign selfHandledCampaign,
      @Nullable NavigationAction navigationAction) {
    this.campaignId = campaignId;
    this.campaignName = campaignName;
    this.customAction = customAction;
    this.selfHandledCampaign = selfHandledCampaign;
    this.navigationAction = navigationAction;
  }

  @Override public String toString() {
    return "MoEInAppCampaign{" +
        "campaignId='" + campaignId + '\'' +
        ", campaignName='" + campaignName + '\'' +
        ", customAction=" + customAction +
        ", selfHandledCampaign=" + selfHandledCampaign +
        ", navigationAction=" + navigationAction +
        '}';
  }
}