package com.moengage.inapp.model;

/**
 * @author Umang Chamaria
 */
public class Margin {
  public final double left;
  public final double right;
  public final double top;
  public final double bottom;

  public Margin(double left, double right, double top, double bottom) {
    this.left = left;
    this.right = right;
    this.top = top;
    this.bottom = bottom;
  }

  @Override public String toString() {
    return "{\"Margin\":{"
        + "\"left\":" + left
        + ", \"right\":" + right
        + ", \"top\":" + top
        + ", \"bottom\":" + bottom
        + "}}";
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Margin margin = (Margin) o;

    if (Double.compare(margin.left, left) != 0) return false;
    if (Double.compare(margin.right, right) != 0) return false;
    if (Double.compare(margin.top, top) != 0) return false;
    return Double.compare(margin.bottom, bottom) == 0;
  }

}
