package com.moengage.inapp.model;

import androidx.annotation.Nullable;
import com.moengage.inapp.model.actions.Action;
import com.moengage.inapp.model.enums.ViewType;
import java.util.List;

/**
 * @author Umang Chamaria
 */
public class InAppWidget extends InAppWidgetBase {

  public final ViewType viewType;

  public final InAppComponent component;
  @Nullable
  public final List<Action> actions;

  public InAppWidget(int id, ViewType viewType, InAppComponent component,
      @Nullable List<Action> actions) {
    super(id);
    this.viewType = viewType;
    this.component = component;
    this.actions = actions;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    InAppWidget that = (InAppWidget) o;

    if (viewType != that.viewType) return false;
    if (!component.equals(that.component)) return false;
    return actions != null ? actions.equals(that.actions) : that.actions == null;
  }

  @Override public String toString() {
    return "InAppWidget{" +
        "viewType=" + viewType +
        ", component=" + component +
        ", actions=" + actions +
        ", id=" + id +
        '}';
  }
}
