package com.moengage.inapp.model;

import androidx.annotation.Nullable;
import com.moengage.inapp.model.meta.InAppCampaign;
import java.util.List;

/**
 * @author Umang Chamaria
 * Date: 2019-05-03
 */
public class InAppMetaResponse {
  public final boolean isSyncSuccess;
  /**
   * List of active campaigns for the user.
   */
  @Nullable public final List<InAppCampaign> campaignMetaList;
  /**
   * Minimum delay between 2 meta api calls.
   */
  public final long syncInterval;
  /**
   * Minimum delay between any 2 in-app campaigns.
   */
  public final long globalDelay;

  public InAppMetaResponse(boolean isSyncSuccess){
    this(isSyncSuccess, null, -1, -1);
  }

  public InAppMetaResponse(boolean isSyncSuccess,
      @Nullable List<InAppCampaign> campaignMetaList, long syncInterval, long globalDelay) {
    this.isSyncSuccess = isSyncSuccess;
    this.campaignMetaList = campaignMetaList;
    this.syncInterval = syncInterval;
    this.globalDelay = globalDelay;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    InAppMetaResponse that = (InAppMetaResponse) o;

    if (isSyncSuccess != that.isSyncSuccess) return false;
    if (syncInterval != that.syncInterval) return false;
    if (globalDelay != that.globalDelay) return false;
    return campaignMetaList != null ? campaignMetaList.equals(that.campaignMetaList)
        : that.campaignMetaList == null;
  }


  @Override public String toString() {
    return "InAppMetaResponse{" +
        "\nisSyncSuccess= " + isSyncSuccess +
        ",\ncampaignMetaList= " + campaignMetaList +
        ",\nsyncInterval= " + syncInterval +
        ",\nglobalDelay= " + globalDelay +
        '}';
  }
}
