package com.moengage.inapp.model;

/**
 * @author Umang Chamaria
 */
public class InAppGlobalState {
  /**
   * Global time delay for in-apps.
   */
  public final long globalDelay;
  /**
   * Last time any in-app was shown.
   */
  public final long lastShowTime;
  /**
   * Current Device time.
   */
  public final long currentDeviceTime;

  public InAppGlobalState(long globalDelay, long lastShowTime, long currentDeviceTime) {
    this.globalDelay = globalDelay;
    this.lastShowTime = lastShowTime;
    this.currentDeviceTime = currentDeviceTime;
  }

  @Override public String toString() {
    return "{\n" +
        "\"globalDelay\": " + globalDelay + ",\n" +
        " \"lastShowTime\": " + lastShowTime + ",\n" +
        " \"currentDeviceTime\": " + currentDeviceTime + ",\n" +
        '}';
  }
}
