package com.moengage.inapp.model;

import com.moengage.inapp.model.enums.Orientation;
import com.moengage.inapp.model.style.InAppStyle;
import java.util.ArrayList;

/**
 * @author Umang Chamaria
 */
public class InAppContainer extends InAppWidgetBase {

  public final InAppStyle style;
  public final Orientation orientation;
  public final boolean isPrimaryContainer;
  public final ArrayList<Widget> widgets;

  public InAppContainer(int id, InAppStyle style, Orientation orientation,
      boolean isPrimaryContainer, ArrayList<Widget> widgets) {
    super(id);
    this.style = style;
    this.orientation = orientation;
    this.isPrimaryContainer = isPrimaryContainer;
    this.widgets = widgets;
  }

  @Override public String toString() {
    return "{\"InAppContainer\":{"
        + "\"style\":" + style
        + ", \"orientation\":\"" + orientation + "\""
        + ", \"isPrimaryContainer\":" + isPrimaryContainer
        + ", \"widgets\":" + widgets
        + ", \"id\":" + id
        + "}}";
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    InAppContainer that = (InAppContainer) o;

    if (isPrimaryContainer != that.isPrimaryContainer) return false;
    if (!style.equals(that.style)) return false;
    if (orientation != that.orientation) return false;
    return widgets.equals(that.widgets);
  }
}
