package com.moengage.inapp.model;

import androidx.annotation.Nullable;

/**
 * @author Umang Chamaria
 * Date: 2019-05-03
 */
public class InAppCampaignResponse {
  public final int responseCode;
  public final boolean isSuccess;
  @Nullable public final CampaignPayload campaignPayload;
  public final boolean hasParsingException;

  public InAppCampaignResponse(int responseCode, boolean isSuccess){
    this(responseCode, isSuccess, null);
  }

  public InAppCampaignResponse(int responseCode, boolean isSuccess, boolean hasParsingException) {
    this(responseCode, isSuccess, null, hasParsingException);
  }

  public InAppCampaignResponse(int responseCode, boolean isSuccess,
      @Nullable CampaignPayload campaignPayload) {
    this(responseCode, isSuccess, campaignPayload, false);
  }

  public InAppCampaignResponse(int responseCode, boolean isSuccess,
      @Nullable CampaignPayload campaignPayload, boolean hasParsingException) {
    this.responseCode = responseCode;
    this.isSuccess = isSuccess;
    this.campaignPayload = campaignPayload;
    this.hasParsingException = hasParsingException;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    InAppCampaignResponse that = (InAppCampaignResponse) o;

    if (responseCode != that.responseCode) return false;
    if (isSuccess != that.isSuccess) return false;
    if (hasParsingException != that.hasParsingException) return false;
    return campaignPayload != null ? campaignPayload.equals(that.campaignPayload)
        : that.campaignPayload == null;
  }
}
