package com.moengage.inapp.model;

import com.moengage.inapp.model.enums.TemplateAlignment;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class CampaignPayload {

  /**
   * A unique identifier for the campaign.
   */
  public final String campaignId;
  /**
   * A readable name for the campaign.
   */
  public final String campaignName;
  public final InAppContainer primaryContainer;
  public final int primaryWidget;
  /**
   *
   */
  public final TemplateAlignment alignment;
  /**
   * Type of template. Embedded, Full Screen, Pop up or Self Handled.
   */
  public final String templateType;
  /**
   *
   */
  public final boolean isCancellable;
  /**
   * Interval after which the campaign should be dismissed if not clicked.
   */
  public final long dismissInterval;
  public final JSONObject campaignPayload;
  public final String customPayload;

  public CampaignPayload(String campaignId, String campaignName,
      InAppContainer primaryContainer, int primaryWidget, String templateType,
      TemplateAlignment alignment, boolean isCancellable, long dismissInterval,
      JSONObject campaignPayload) {
    this(campaignId, campaignName, primaryContainer, primaryWidget,
        alignment, templateType, isCancellable, dismissInterval, campaignPayload, null);
  }

  public CampaignPayload(String campaignId, String campaignName, TemplateAlignment alignment,
      String templateType, boolean isCancellable, long dismissInterval,
      JSONObject campaignPayload, String customPayload) {
    this(campaignId, campaignName, null, -1, alignment, templateType, isCancellable,
        dismissInterval, campaignPayload, customPayload);
  }

  CampaignPayload(String campaignId, String campaignName,
      InAppContainer primaryContainer, int primaryWidget,
      TemplateAlignment alignment, String templateType, boolean isCancellable, long dismissInterval,
      JSONObject campaignPayload, String customPayload) {
    this.campaignId = campaignId;
    this.campaignName = campaignName;
    this.primaryContainer = primaryContainer;
    this.primaryWidget = primaryWidget;
    this.alignment = alignment;
    this.templateType = templateType;
    this.isCancellable = isCancellable;
    this.dismissInterval = dismissInterval;
    this.campaignPayload = campaignPayload;
    this.customPayload = customPayload;
  }

  @Override public String toString() {
    return "CampaignPayload{" +
        "campaignId='" + campaignId + '\'' +
        ", campaignName='" + campaignName + '\'' +
        ", primaryContainer=" + primaryContainer +
        ", primaryWidget=" + primaryWidget +
        ", alignment=" + alignment +
        ", templateType='" + templateType + '\'' +
        ", isCancellable=" + isCancellable +
        ", dismissInterval=" + dismissInterval +
        ", campaignPayload=" + campaignPayload +
        '}';
  }
}
