package com.moengage.inapp.model;

import androidx.annotation.Nullable;

/**
 * @author Umang Chamaria
 */
public class Border {

  @Nullable public final Color color;
  public final double radius;
  public final double width;

  public Border(@Nullable Color color, double radius, double width) {
    this.color = color;
    this.radius = radius;
    this.width = width;
  }

  @Override public String toString() {
    return "Border{" + "color='" + color + '\'' + ", radius=" + radius + ", width=" + width + '}';
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Border border = (Border) o;

    if (Double.compare(border.radius, radius) != 0) return false;
    if (Double.compare(border.width, width) != 0) return false;
    return color != null ? color.equals(border.color) : border.color == null;
  }
}
