package com.moengage.inapp.model;

/**
 * @author Umang Chamaria
 */
public class Animation {
  public final int entry;
  public final int exit;

  public Animation(int entry, int exit) {
    this.entry = entry;
    this.exit = exit;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Animation animation = (Animation) o;

    if (entry != animation.entry) return false;
    return exit == animation.exit;
  }

  @Override public String toString() {
    return "Animation{" + "entry=" + entry + ", exit=" + exit + '}';
  }
}
