package com.moengage.inapp.listeners;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.moengage.core.Logger;
import com.moengage.inapp.model.MoEInAppCampaign;

/**
 * Interface definition for callback which is invoked at various stages of showing in-apps.
 *
 * @author Umang Chamaria
 * @since 10.0.00
 */
public class InAppMessageListener {

  private static final String TAG = "InAppMessageListener";

  /**
   * Callback triggered whenever in-app is shown.
   *
   * @param inAppCampaign instance of {@link MoEInAppCampaign}
   * @since 10.0.00
   */
  @MainThread
  public void onShown(@NonNull MoEInAppCampaign inAppCampaign){
    Logger.v(TAG + " onShown() : InApp Shown Callback triggered. Campaign: " + inAppCampaign);
  }

  /**
   * Callback triggered whenever user clicks on any UI widget of the In-App with navigation actionType.
   * SDK will only handle re-direction if the API returns false, if the API returns true it is
   * the onus of the app to handle redirection.
   *
   * @return true if the app is taking care of navigation else false.
   * @since 10.0.00
   */
  public boolean onNavigation(@NonNull MoEInAppCampaign inAppCampaign){
    Logger.v(TAG + " onNavigation() : InApp Click navigation callback triggered. Campaign: " + inAppCampaign);
    return false;
  }

  /**
   * Callback triggered whenever in-app is closed.
   *
   * @param inAppCampaign instance of {@link MoEInAppCampaign}
   * @since 10.0.00
   */
  @MainThread
  public void onClosed(@NonNull MoEInAppCampaign inAppCampaign){
    Logger.v(TAG + " onClosed() : InApp Closed callback triggered. Campaign: " + inAppCampaign);
  }

  /**
   * Callback for custom actionType on in-app click.
   * @param inAppCampaign instance of {@link MoEInAppCampaign}
   * This callback is triggered on the main thread.
   * @since 10.0.00
   */
  @MainThread
  public void onCustomAction(@NonNull MoEInAppCampaign inAppCampaign){
    Logger.v(TAG + " onCustomAction() : InApp Click custom action triggered. Campaign: " + inAppCampaign);
  }

  /**
   * Callback triggered whenever a self handled campaign is available.
   * Call {@link MoEInAppCampaign#selfHandledCampaign} to get the self handled triggerMeta.
   * This callback is triggered on the main thread.
   *
   * @param inAppCampaign instance of {@link MoEInAppCampaign}
   * @since 10.0.00
   */
  @MainThread
  public void onSelfHandledAvailable(@NonNull MoEInAppCampaign inAppCampaign){
    Logger.v(TAG + " onSelfHandledAvailable() : Self-Handled InApp Callback triggered. Campaign: " + inAppCampaign);
  }
}