package com.moengage.inapp;

import android.content.Context;
import com.moengage.inapp.model.CampaignStats;
import com.moengage.inapp.model.enums.EvaluationStatusCode;
import com.moengage.inapp.model.meta.InAppCampaign;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-10-11
 */
public class StatsLogger {

  private static StatsLogger instance;

  private Map<String, CampaignStats> stats;

  private static final String TAG = "StatsLogger";

  private StatsLogger() {
    stats = new HashMap<>();
  }

  public static StatsLogger getInstance() {
    if (instance == null) {
      synchronized (StatsLogger.class) {
        if (instance == null) instance = new StatsLogger();
      }
    }
    return instance;
  }

  public void logCampaignAttempted(List<InAppCampaign> campaignMetaList) {
    //bulkLogging(campaignMetaList, CAMPAIGN_ATTEMPTED);
  }

  public void logCampaignNotPrioritized(List<InAppCampaign> inAppCampaignList) {
    //bulkLogging(inAppCampaignList, PRIORITY_STAGE_HIGHER_PRIORITY_CAMPAIGN_AVAILABLE);
  }

  public void logDeviceOrientationNotSupported(List<InAppCampaign> inAppCampaignList) {
    //bulkLogging(inAppCampaignList, PRIORITY_STAGE_ORIENTATION_UNSUPPORTED);
  }

  public void logPriorityStageFailure(InAppCampaign campaign, EvaluationStatusCode statusCode) {
/*    updateStatForCampaign(campaign.campaignMeta.campaignId, MoEUtils.currentISOTime(),
        priorityStageFailureMap.get(statusCode));*/
  }

  public void logImpressionStageFailure(InAppCampaign campaign, EvaluationStatusCode statusCode) {
/*    updateStatForCampaign(campaign.campaignMeta.campaignId, MoEUtils.currentISOTime(),
        impressionStageFailureMap.get(statusCode));*/
  }


  private void bulkLogging(List<InAppCampaign> campaignList, String reason) {
/*    String timestamp = MoEUtils.currentISOTime();
    for (InAppCampaign campaignMeta : campaignList) {
      updateStatForCampaign(campaignMeta.campaignMeta.campaignId, timestamp, reason);
    }*/
  }

  public void updateStatForCampaign(String campaignId, String timestamp, String reason) {
/*    CampaignStats campaignStats = stats.get(campaignId);
    if (campaignStats == null) {
      campaignStats = new CampaignStats();
      List<String> timestampList = new ArrayList<>();
      timestampList.add(timestamp);
      campaignStats.reasons.put(reason, timestampList);
      stats.put(campaignId, campaignStats);
      return;
    }
    List<String> occurrencesList = campaignStats.reasons.get(reason);
    if (occurrencesList == null) {
      List<String> timestampList = new ArrayList<>();
      timestampList.add(timestamp);
      campaignStats.reasons.put(reason, timestampList);
    } else {
      occurrencesList.add(timestamp);
    }*/
  }

  public void writeStatsToStorage(Context context) {
/*    try {
      if (stats.isEmpty()){
        Logger.v(TAG + " writeStatsToStorage() : No stats to store");
        return;
      }
      JSONObject statsJson = new JSONObject();
      for (Map.Entry<String, CampaignStats> entry : stats.entrySet()) {
        statsJson.put(entry.getKey(), campaignStatToJson(entry.getValue()));
      }
      Logger.v(TAG + " writeStatsToStorage() : Recorded Stats - " + statsJson.toString());
      InAppInjector.getInstance().getInAppRepository(context).localRepository.writeStats(statsJson);
      stats = new HashMap<>();
    } catch (Exception e) {
      Logger.e( TAG + " writeStatsToStorage() : ", e);
    }*/
  }

  JSONObject campaignStatToJson(CampaignStats stats) throws JSONException {
    JSONObject campaignStatJson = new JSONObject();
    for (Map.Entry<String, List<String>> entry : stats.reasons.entrySet()) {
      campaignStatJson.put(entry.getKey(), listToJsonArray(entry.getValue()));
    }
    return campaignStatJson;
  }

  private JSONArray listToJsonArray(List<String> timestampList){
    JSONArray jsonArray = new JSONArray();
    for (String timeStamp: timestampList){
      jsonArray.put(timeStamp);
    }
    return jsonArray;
  }

  private static final String CAMPAIGN_ATTEMPTED = "ATM";
  // Campaign priority stage
  static final String PRIORITY_STAGE_HIGHER_PRIORITY_CAMPAIGN_AVAILABLE =
      "PRT_HIGH_PRT_CMP_AVL";
  private static final String PRIORITY_STAGE_MAX_TIMES_SHOWN = "PRT_MAX_TIM_SWN";
  private static final String PRIORITY_STAGE_CAMPAIGN_DELAY = "PRT_MIN_DEL";
  private static final String PRIORITY_STAGE_GLOBAL_DELAY = "PRT_GBL_DEL";
  private static final String PRIORITY_STAGE_INVALID_SCREEN = "PRT_SCR_MISMATCH";
  private static final String PRIORITY_STAGE_INVALID_CONTEXT = "PRT_CTX_MISMATCH";
  private static final String PRIORITY_STAGE_PERSISTENCE = "PRT_PERST";
  private static final String PRIORITY_STAGE_EXPIRY = "PRT_EXP";
  private static final String PRIORITY_STAGE_ORIENTATION_UNSUPPORTED = "PRT_ORT_UNSPP";
  private static final String PRIORITY_STAGE_INAPP_BLOCKED = "PRT_INAPP_BLK";
  // Campaign delivery Stage
  public static final String DELIVERY_STAGE_API_FAILURE = "DLV_API_FLR";
  static final String IMPRESSION_STAGE_ANOTHER_CAMPAIGN_VISIBLE = "IMP_ANTR_CMP_VISB";
  // Campaign impression
  static final String IMPRESSION_STAGE_IMAGE_DOWNLOAD_FAILURE = "IMP_IMG_FTH_FLR";
  static final String IMPRESSION_STAGE_GIF_LIBRARY_NOT_PRESENT = "IMP_GIF_LIB_MIS";
  static final String IMPRESSION_STAGE_HEIGHT_EXCEEDS_DEVICE = "IMP_HGT_EXD_DEVC";
  public static final String DELIVERY_STAGE_MANDATORY_PARAM_MISSING = "DLV_MAND_PARM_MIS";
  private static final String IMPRESSION_STAGE_MAX_TIMES_SHOWN = "IMP_MAX_TIM_SHW";
  private static final String IMPRESSION_STAGE_CAMPAIGN_DELAY = "IMP_MIN_DEL";
  private static final String IMPRESSION_STAGE_GLOBAL_DELAY = "IMP_GBL_DEL";
  private static final String IMPRESSION_STAGE_SCREEN_CHANGE = "IMP_SCR_CHG";
  private static final String IMPRESSION_STAGE_CONTEXT_CHANGE = "IMP_CTX_CHG";
  private static final String IMPRESSION_STAGE_PERSISTENCE = "IMP_PERST";
  private static final String IMPRESSION_STAGE_EXPIRY = "IMP_EXP";
  static final String IMPRESSION_STAGE_ORIENTATION_UNSUPPORTED = "IMP_ORT_UNSPP";
  private static final String IMPRESSION_STAGE_INAPP_BLOCKED = "IMP_INAPP_BLK";

  private static Map<EvaluationStatusCode, String> priorityStageFailureMap = new HashMap<>();
  private static Map<EvaluationStatusCode, String> impressionStageFailureMap = new HashMap<>();

/*  static {

    priorityStageFailureMap.put(EvaluationStatusCode.GLOBAL_DELAY, PRIORITY_STAGE_GLOBAL_DELAY);
    priorityStageFailureMap.put(EvaluationStatusCode.EXPIRY, PRIORITY_STAGE_EXPIRY);
    priorityStageFailureMap.put(EvaluationStatusCode.INVALID_SCREEN, PRIORITY_STAGE_INVALID_SCREEN);
    priorityStageFailureMap.put(EvaluationStatusCode.INVALID_CONTEXT,
        PRIORITY_STAGE_INVALID_CONTEXT);
    priorityStageFailureMap.put(EvaluationStatusCode.PERSISTENT, PRIORITY_STAGE_PERSISTENCE);
    priorityStageFailureMap.put(EvaluationStatusCode.MAX_COUNT, PRIORITY_STAGE_MAX_TIMES_SHOWN);
    priorityStageFailureMap.put(EvaluationStatusCode.CAMPAIGN_DELAY, PRIORITY_STAGE_CAMPAIGN_DELAY);
    priorityStageFailureMap.put(EvaluationStatusCode.BLOCKED_ON_SCREEN,
        PRIORITY_STAGE_INAPP_BLOCKED);

    impressionStageFailureMap.put(EvaluationStatusCode.GLOBAL_DELAY, IMPRESSION_STAGE_GLOBAL_DELAY);
    impressionStageFailureMap.put(EvaluationStatusCode.EXPIRY, IMPRESSION_STAGE_EXPIRY);
    impressionStageFailureMap.put(EvaluationStatusCode.INVALID_SCREEN,
        IMPRESSION_STAGE_SCREEN_CHANGE);
    impressionStageFailureMap.put(EvaluationStatusCode.INVALID_CONTEXT,
        IMPRESSION_STAGE_CONTEXT_CHANGE);
    impressionStageFailureMap.put(EvaluationStatusCode.PERSISTENT, IMPRESSION_STAGE_PERSISTENCE);
    impressionStageFailureMap.put(EvaluationStatusCode.MAX_COUNT, IMPRESSION_STAGE_MAX_TIMES_SHOWN);
    impressionStageFailureMap.put(EvaluationStatusCode.CAMPAIGN_DELAY,
        IMPRESSION_STAGE_CAMPAIGN_DELAY);
    impressionStageFailureMap.put(EvaluationStatusCode.BLOCKED_ON_SCREEN,
        IMPRESSION_STAGE_INAPP_BLOCKED);

  }*/
}
