package com.moengage.inapp;

import android.content.Context;
import com.moengage.inapp.repository.InAppCache;
import com.moengage.inapp.repository.InAppRepository;
import com.moengage.inapp.repository.LocalRepository;
import com.moengage.inapp.repository.remote.RemoteRepository;

/**
 * @author Umang Chamaria
 */
public class InAppInjector {

  private InAppRepository inAppRepository;

  private static InAppInjector instance = null;

  private InAppInjector() {

  }

  public InAppRepository getInAppRepository(Context context) {
    if (inAppRepository == null) {
      inAppRepository = new InAppRepository(new LocalRepository(context), new RemoteRepository(),
          new InAppCache());
    }
    return inAppRepository;
  }

  public static InAppInjector getInstance() {
    if (instance == null) {
      synchronized (InAppInjector.class){
        if (instance == null) instance = new InAppInjector();
      }
    }
    return instance;
  }
}
