/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.inapp.InAppHandler;
import com.moengage.core.model.InAppV2Meta;
import com.moengage.core.model.InAppV3Meta;
import com.moengage.inapp.model.meta.CampaignMeta;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.DeliveryControl;
import com.moengage.inapp.model.meta.DisplayControl;
import com.moengage.inapp.model.meta.FrequencyCapping;
import com.moengage.inapp.model.meta.Rules;

/**
 * @author Umang Chamaria
 */
public class InAppHandlerImpl implements InAppHandler {

  private static final String TAG = InAppConstants.MODULE_TAG + "InAppHandlerImpl";

  @Override public void showInAppIfRequired(Context context) {
    if (SdkConfig.getConfig().isLifecycleInAppOptedOut) {
      Logger.v(TAG + " showInAppIfRequired() : lifecycle campaigns opted out cannot show in-app");
      return;
    }
    if (!InAppController.getInstance().isInAppSynced()) {
      Logger.v(TAG + " showInAppIfRequired() : Sync pending, cannot show in-app now.");
      return;
    }
    InAppController.getInstance().tryToShowInApp(context);
  }

  @Override public void showTriggerInAppIfPossible(Context context, Event event) {
    InAppController.getInstance().tryToShowTriggerInAppIfPossible(context, event);
  }

  @Override public void unregisterInAppManager(Activity currentActivity) {
    InAppController.getInstance().unRegisterActivity(currentActivity);
  }

  @Override public void registerInAppManager(Activity currentActivity) {
    InAppController.getInstance().registerActivity(currentActivity);
  }

  @Override public void onAppClose(Context context) {
    InAppController.getInstance().onAppClose(context);
    //MoEDispatcher.getInstance(context).startTask(new UploadStatsTask(context));
  }

  @Override public void onLogout(Context context) {
    InAppController.getInstance().setInAppSynced(false);
    InAppInjector.getInstance().getInAppRepository(context).onLogout(context);
  }

  @Override public void syncInAppIfRequired(Context context) {
    InAppController.getInstance().syncInApps(context);
  }

  @Override public InAppV3Meta generateMetaForV2Campaign(InAppV2Meta inAppV2Meta) {

    CampaignMeta meta = new CampaignMeta(
        inAppV2Meta.campaignId,
        "",
        inAppV2Meta.expiry,
        0,
        new DisplayControl(new Rules(null, null)),
        "",
        new DeliveryControl(inAppV2Meta.priority,
            new FrequencyCapping(false, 0, 0), true),
        null);

    CampaignState campaignState = new CampaignState(inAppV2Meta.showCount,
        inAppV2Meta.lastShowTime / 1000, inAppV2Meta.isClicked == 1);

    return new InAppV3Meta(CampaignMeta.toJson(meta), CampaignState.toJson(campaignState));
  }

  @Override public void showInAppFromPush(Context context, Bundle pushPayload) {
    InAppController.getInstance().showInAppFromPush(context, pushPayload);
  }
}
