/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.push;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.push.PushBaseHandler;
import com.moengage.push.PushHandler;

public class PushManager {
    private static final String TAG = "Core_PushManager";
    private PushBaseHandler pushBaseHandler;
    private static PushManager instance = null;
    private PushHandler pushHandler;
    private OnTokenReceivedListener tokenListener;

    private PushManager() {
        this.loadPushHandler();
    }

    private void loadPushHandler() {
        try {
            Class<?> baseHandler = Class.forName("com.moengage.pushbase.PushBaseHandlerImpl");
            this.pushBaseHandler = (PushBaseHandler)baseHandler.newInstance();
            Class<?> handler = Class.forName("com.moengage.firebase.PushHandlerImpl");
            this.pushHandler = (PushHandler)handler.newInstance();
            Logger.v("PushManager:loadPushHandler FCM Enabled");
        }
        catch (Exception e) {
            Logger.i("Core_PushManager loadPushHandler() : Did not find push module.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushManager getInstance() {
        if (instance != null) return instance;
        Class<PushManager> clazz = PushManager.class;
        synchronized (PushManager.class) {
            if (instance != null) return instance;
            instance = new PushManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public void setMessageListener(Object messageListener) {
        if (this.pushBaseHandler != null) {
            this.pushBaseHandler.setPushMessageListener(messageListener);
        }
    }

    @Deprecated
    public void refreshToken(Context context, String token) {
        if (context == null || MoEUtils.isEmptyString(token) || this.pushHandler == null) {
            return;
        }
        this.pushHandler.passPushToken(context, token);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void registerForPush(Context context) {
        if (this.pushHandler != null) {
            this.pushHandler.registerForPushToken(context);
        }
    }

    @Nullable
    public PushHandler getPushHandler() {
        return this.pushHandler;
    }

    @Deprecated
    public void setTokenObserver(OnTokenReceivedListener tokenObserver) {
        this.tokenListener = tokenObserver;
    }

    public void notifyTokenChange(String token) {
        try {
            if (this.tokenListener != null) {
                this.tokenListener.onTokenReceived(token);
            }
        }
        catch (Exception e) {
            Logger.e("Core_PushManager notifyTokenChange() : ", e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onAppOpen(Context context) {
        if (context != null && this.pushBaseHandler != null) {
            this.pushBaseHandler.onAppOpen(context);
        }
    }

    @Deprecated
    public static interface OnTokenReceivedListener {
        public void onTokenReceived(String var1);
    }
}

