/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import com.moengage.core.Logger;
import java.lang.reflect.InvocationTargetException;

public final class ReflectionUtils {
    private ReflectionUtils() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    public static Object invokeStatic(Class<?> classObject, String methodName, Class<?>[] types, Object[] args) {
        return ReflectionUtils.invocationHelper(null, classObject, null, methodName, null, types, args);
    }

    public static Object invokeStatic(String className, String methodName, Class<?>[] types, Object[] args) {
        return ReflectionUtils.invocationHelper(null, null, className, methodName, null, types, args);
    }

    public static Object getAttribute(String className, String attrName) {
        if (null == attrName || attrName.isEmpty()) {
            return null;
        }
        return ReflectionUtils.invocationHelper(null, null, className, attrName, null, null, null);
    }

    public static Object invokeInstance(Object target, String methodName, Class<?>[] types, Object[] args) {
        return ReflectionUtils.invocationHelper(target, null, null, methodName, null, types, args);
    }

    private static Object invocationHelper(Object target, Class<?> classObject, String className, String methodName, String attributeName, Class<?>[] argTypes, Object[] args) {
        try {
            Class<?> cls = classObject != null ? classObject : (target != null ? target.getClass() : Class.forName(className));
            if (attributeName != null) {
                return cls.getField(attributeName);
            }
            if (null != methodName) {
                return cls.getMethod(methodName, argTypes).invoke(target, args);
            }
            return cls;
        }
        catch (NoSuchMethodException e) {
            Logger.e("ReflectionUtils:invocationHelper", e);
        }
        catch (IllegalAccessException e) {
            Logger.e("ReflectionUtils:invocationHelper", e);
        }
        catch (InvocationTargetException e) {
            Logger.e("ReflectionUtils:invocationHelper", e);
        }
        catch (ClassNotFoundException e) {
            Logger.e("ReflectionUtils:invocationHelper", e);
        }
        catch (Exception e) {
            Logger.e("ReflectionUtils:invocationHelper", e);
        }
        return null;
    }

    public static boolean isClassPresentInPath(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            Logger.e("ReflectionUtils:isClassPresentInPath" + e.getMessage());
            return false;
        }
    }
}

