/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.userattributes;

import android.content.Context;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.RemoteConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.internal.userattributes.TrackAttributeTask;
import org.json.JSONObject;

public class MoEAttributeManager {
    private static final String TAG = "Core_MoEAttributeManager";
    private Context context;

    public MoEAttributeManager(Context context) {
        this.context = context;
    }

    public void setUserAttribute(JSONObject userJson) {
        if (!this.shouldTrackUserAttribute()) {
            return;
        }
        TaskManager.getInstance().addTaskToQueueBeginning(new TrackAttributeTask(this.context, userJson, false));
    }

    public void setCustomUserAttribute(JSONObject userJson) {
        if (!this.shouldTrackUserAttribute()) {
            return;
        }
        TaskManager.getInstance().addTaskToQueueBeginning(new TrackAttributeTask(this.context, userJson, true));
    }

    private boolean shouldTrackUserAttribute() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (!RemoteConfig.getConfig().isAppEnabled) {
            Logger.i("Core_MoEAttributeManager shouldTrackUserAttribute(): Account disabled will not track attribute");
            return false;
        }
        if (provider.isDataTrackingOptedOut()) {
            Logger.i("Core_MoEAttributeManager shouldTrackUserAttribute(): Data tracking opt-ed out cannot track attribute");
            return false;
        }
        return true;
    }
}

