/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.storage.repository.local;

import android.content.Context;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.storage.StorageProvider;
import com.moengage.core.internal.storage.preference.SharedPrefHelper;
import com.moengage.core.internal.storage.repository.local.LocalRepository;
import com.moengage.core.model.PushTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/moengage/core/internal/storage/repository/local/LocalRepositoryImpl;", "Lcom/moengage/core/internal/storage/repository/local/LocalRepository;", "context", "Landroid/content/Context;", "sdkConfig", "Lcom/moengage/core/SdkConfig;", "(Landroid/content/Context;Lcom/moengage/core/SdkConfig;)V", "getConfigSyncTime", "", "getPushTokens", "Lcom/moengage/core/model/PushTokens;", "isDeviceRegistered", "", "setDeviceRegistrationState", "", "state", "updateConfigApiSyncTime", "time", "core_release"})
public final class LocalRepositoryImpl
implements LocalRepository {
    private final Context context;
    private final SdkConfig sdkConfig;

    @Override
    public long getConfigSyncTime() {
        return StorageProvider.INSTANCE.getSharedPreference(this.context, this.sdkConfig).getLong("last_config_sync_time", 0L);
    }

    @Override
    public void updateConfigApiSyncTime(long time) {
        StorageProvider.INSTANCE.getSharedPreference(this.context, this.sdkConfig).putLong("last_config_sync_time", time);
    }

    @Override
    @NotNull
    public PushTokens getPushTokens() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        SharedPrefHelper sharePrefHelper = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig);
        return new PushTokens(sharePrefHelper.getString("registration_id", ""), sharePrefHelper.getString("mi_push_token", ""));
    }

    @Override
    public boolean isDeviceRegistered() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        return StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getBoolean("is_device_registered", false);
    }

    @Override
    public void setDeviceRegistrationState(boolean state) {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).putBoolean("is_device_registered", state);
    }

    public LocalRepositoryImpl(@NotNull Context context, @NotNull SdkConfig sdkConfig) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sdkConfig, (String)"sdkConfig");
        this.context = context;
        this.sdkConfig = sdkConfig;
    }
}

