/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.storage.preference;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.moengage.core.SdkConfig;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\bH\u0007J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ$\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0011J\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fJ\u001c\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/moengage/core/internal/storage/preference/SharedPrefHelper;", "", "context", "Landroid/content/Context;", "config", "Lcom/moengage/core/SdkConfig;", "(Landroid/content/Context;Lcom/moengage/core/SdkConfig;)V", "preferences", "Landroid/content/SharedPreferences;", "getBoolean", "", "key", "", "defaultValue", "getInt", "", "getLong", "", "getPreference", "getString", "getStringSet", "", "putBoolean", "", "value", "putInt", "putLong", "putString", "putStringSet", "stringSet", "removeKey", "core_release"})
public final class SharedPrefHelper {
    private final SharedPreferences preferences;
    private final Context context;
    private final SdkConfig config;

    public final void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.preferences.edit().putString(key, value).apply();
    }

    @Nullable
    public final String getString(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        return this.preferences.getString(key, defaultValue);
    }

    public final void putInt(@NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.preferences.edit().putInt(key, value).apply();
    }

    public final int getInt(@NotNull String key, int defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preferences.getInt(key, defaultValue);
    }

    public final void putLong(@NotNull String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.preferences.edit().putLong(key, value).apply();
    }

    public final long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preferences.getLong(key, defaultValue);
    }

    public final void putBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.preferences.edit().putBoolean(key, value).apply();
    }

    public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preferences.getBoolean(key, defaultValue);
    }

    public final void putStringSet(@NotNull String key, @NotNull Set<String> stringSet) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(stringSet, (String)"stringSet");
        this.preferences.edit().putStringSet(key, stringSet).apply();
    }

    @Nullable
    public final Set<String> getStringSet(@NotNull String key, @NotNull Set<String> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        return this.preferences.getStringSet(key, defaultValue);
    }

    public final void removeKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.preferences.edit().remove(key).apply();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final SharedPreferences getPreference() {
        return this.preferences;
    }

    public SharedPrefHelper(@NotNull Context context, @NotNull SdkConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("pref_moe", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
        this.preferences = sharedPreferences;
    }
}

