/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.security;

import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AESHandler {
    private static final String TAG = "Core_AESHandler";
    private static final int BLOCK_SIZE = 16;
    private static final String CHARSET_NAME = "UTF-8";

    public static String encrypt(@NonNull String key, String plainText) throws Exception {
        if (MoEUtils.isEmptyString(key) || MoEUtils.isEmptyString(plainText)) {
            Logger.v("Core_AESHandler encrypt() : key/text is null.");
            return null;
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "AES");
        IvParameterSpec ivParameterSpec = AESHandler.generateIvParameterSpec();
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        return Base64.encodeToString((byte[])AESHandler.addIV(cipher.doFinal(plainText.getBytes(CHARSET_NAME)), ivParameterSpec.getIV()), (int)0);
    }

    public static String decrypt(@NonNull String key, String encryptedText) throws Exception {
        if (MoEUtils.isEmptyString(key) || MoEUtils.isEmptyString(encryptedText)) {
            Logger.v("Core_AESHandler decrypt() : key/text is null.");
            return null;
        }
        byte[] encryptedBytes = Base64.decode((byte[])encryptedText.getBytes(CHARSET_NAME), (int)0);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "AES");
        IvParameterSpec ivParameterSpec = AESHandler.getIvParameterSpec(encryptedBytes);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        return new String(cipher.doFinal(AESHandler.removeIV(encryptedBytes)));
    }

    private static IvParameterSpec generateIvParameterSpec() {
        byte[] iv = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    private static IvParameterSpec getIvParameterSpec(byte[] encryptedBytes) {
        byte[] iv = new byte[16];
        System.arraycopy(encryptedBytes, 0, iv, 0, 16);
        return new IvParameterSpec(iv);
    }

    private static byte[] addIV(byte[] plainBytes, byte[] ivBytes) {
        int ivLen = ivBytes.length;
        int textLen = plainBytes.length;
        byte[] plaintTextWithIv = new byte[ivBytes.length + plainBytes.length];
        System.arraycopy(ivBytes, 0, plaintTextWithIv, 0, ivLen);
        System.arraycopy(plainBytes, 0, plaintTextWithIv, ivLen, textLen);
        return plaintTextWithIv;
    }

    private static byte[] removeIV(byte[] encryptedBytes) {
        int textLen = encryptedBytes.length;
        byte[] encryptedBytesNoIv = new byte[textLen - 16];
        System.arraycopy(encryptedBytes, 16, encryptedBytesNoIv, 0, textLen - 16);
        return encryptedBytesNoIv;
    }
}

