/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.reports;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.reports.DataManager;
import com.moengage.core.model.MoEJobParameters;

class SendInteractionDataTask
extends SDKTask {
    @Nullable
    private final MoEJobParameters jobParameters;
    private final int attemptNumber;
    private final String TAG = "Core_SendInteractionDataTask";

    SendInteractionDataTask(Context context) {
        this(context, null, -1);
    }

    SendInteractionDataTask(Context context, @Nullable MoEJobParameters jobParameters, int attemptNumber) {
        super(context);
        this.jobParameters = jobParameters;
        this.attemptNumber = attemptNumber;
    }

    @Override
    public TaskResult execute() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return null;
            }
            Logger.v("Core_SendInteractionDataTask executing task");
            DataManager.getInstance().sendData(this.context, SdkConfig.getConfig().appId, this.attemptNumber);
            this.releaseJobLockIfRequired();
            Logger.v("Core_SendInteractionDataTask : completed task");
            return null;
        }
        catch (Exception e) {
            Logger.e("Core_SendInteractionDataTask : execute() ", e);
            return null;
        }
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobParameters != null) {
            Logger.v("Core_SendInteractionDataTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobParameters.jobCompleteListener.jobComplete(this.jobParameters);
        }
    }

    @Override
    public String getTaskTag() {
        return "SEND_INTERACTION_DATA";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

