/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.reports;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.RestUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.AdvertisingIdClient;
import com.moengage.core.internal.reports.DataManager;
import com.moengage.core.internal.reports.ReportsBatchHelper;
import com.moengage.core.internal.storage.StorageProvider;
import com.moengage.core.model.BatchData;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.PushTokens;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.JsonBuilder;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class DataSyncHelper {
    private static final String TAG = "Core_DataSyncHelper";
    private final Object lock = new Object();

    DataSyncHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncData(Context context, String appId, int attemptNumber) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = false;
            ArrayList<BatchData> batchedData = null;
            String endpoint = "v2/sdk/report/" + appId;
            if (this.shouldSendDataToTestServer(context)) {
                endpoint = "integration/send_report_add_call";
            }
            ReportsBatchHelper batchHelper = new ReportsBatchHelper();
            while (true) {
                if ((batchedData = MoEDAO.getInstance(context).getBatchedData(100)) == null || batchedData.isEmpty()) {
                    Logger.v("Core_DataSyncHelper syncData() : Nothing found to send.");
                    return;
                }
                for (BatchData data : batchedData) {
                    BatchData batch = batchHelper.updateBatchIfRequired(context, data);
                    try {
                        String requestId = this.getRequestID(data.batchDataJson);
                        JSONObject requestBody = this.cleanBody(data.batchDataJson).put("query_params", (Object)this.getQueryParams(context));
                        Response response = APIManager.reportAdd(appId, endpoint, requestId, requestBody);
                        if (response != null && (response.responseCode == 200 || response.responseCode == MoEConstants.ENCRYPTION_FAIL)) {
                            result = true;
                        }
                    }
                    catch (Exception e) {
                        Logger.e("Core_DataSyncHelper syncData() : ", e);
                        result = false;
                    }
                    if (result) {
                        Logger.v("Core_DataSyncHelper syncData() : Batch sent successfully deleting batch");
                        MoEDAO.getInstance(context).deleteBatch(batch);
                        continue;
                    }
                    Logger.v("Core_DataSyncHelper syncData() : Will try to schedule retry.");
                    this.scheduleRetryIfRequired(context, attemptNumber);
                    break;
                }
                if (!result) break;
                batchedData.clear();
            }
        }
    }

    private void scheduleRetryIfRequired(Context context, int attemptNumber) {
        Logger.v("Core_DataSyncHelper scheduleRetryIfRequired() : Attempt Number: " + attemptNumber);
        switch (attemptNumber) {
            case 1: {
                DataManager.getInstance().scheduleImmediateRetry(context, DataManager.INTERVAL_RETRY_ONE, 2);
                break;
            }
            case 2: {
                DataManager.getInstance().scheduleImmediateRetry(context, DataManager.INTERVAL_RETRY_TWO, -1);
                break;
            }
            default: {
                Logger.v("Core_DataSyncHelper scheduleRetryIfRequired() : Will not retry.");
            }
        }
    }

    private boolean shouldSendDataToTestServer(Context context) {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        return provider.isDeviceRegisteredForVerification() && provider.getVerificationRegistrationTime() + MoEUtils.minutesToMillis(DataManager.MAX_TEST_DEVICE_TIME) > MoEUtils.currentMillis();
    }

    @Nullable
    private String getRequestID(JSONObject batchData) {
        try {
            return batchData.getString("MOE-REQUEST-ID");
        }
        catch (JSONException e) {
            Logger.e("SendInteractionDataTask: getRequestID(): Exception ", e);
            return null;
        }
    }

    private JSONObject cleanBody(JSONObject batchData) {
        batchData.remove("MOE-REQUEST-ID");
        return batchData;
    }

    private JSONObject getQueryParams(Context context) throws JSONException {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        JsonBuilder builder = RestUtils.getDefaultParams(context);
        builder.putString("device_tz", TimeZone.getDefault().getID());
        DevicePreferences devicePreferences = MoEDAO.getInstance(context).getDevicePreferences();
        if (!devicePreferences.isPushOptedOut) {
            PushTokens pushTokens = StorageProvider.INSTANCE.getRepository(context, SdkConfig.getConfig()).getPushTokens();
            if (!MoEUtils.isEmptyString(pushTokens.fcmToken)) {
                builder.putString("push_id", pushTokens.fcmToken);
            }
            if (!MoEUtils.isEmptyString(pushTokens.oemToken)) {
                builder.putString("mi_push_id", pushTokens.oemToken);
            }
        }
        if (!devicePreferences.isDataTrackingOptedOut) {
            String androidId = MoEUtils.getAndroidID(context);
            if (!MoEUtils.isEmptyString(androidId)) {
                builder.putString("android_id", androidId);
            }
            if (!SdkConfig.getConfig().trackingOptOut.isGaidOptedOut()) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = provider.getStoredGAID();
                if (MoEUtils.isEmptyString(gaid) && (adInfo = MoEUtils.getAdvertisementInfo(context)) != null) {
                    gaid = adInfo.getId();
                    provider.storeGAID(gaid);
                }
                if (!MoEUtils.isEmptyString(gaid)) {
                    builder.putString("moe_gaid", gaid);
                }
            }
            builder.putString("os_ver", String.valueOf(Build.VERSION.SDK_INT)).putString("model", Build.MODEL).putString("app_version_name", provider.getAppVersionName());
            String nwType = MoEUtils.getNetworkType(context);
            if (!MoEUtils.isEmptyString(nwType)) {
                builder.putString("networkType", nwType);
            }
        }
        return builder.build();
    }
}

