/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.reports;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Looper;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.internal.analytics.AnalyticsHelper;
import com.moengage.core.internal.reports.BatchDataTask;
import com.moengage.core.internal.reports.DataSyncHelper;
import com.moengage.core.internal.reports.ReportsBatchHelper;
import com.moengage.core.model.MoEJobParameters;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DataManager {
    private static final String TAG = "Core_DataManager";
    private static DataManager instance = null;
    private final ReportsBatchHelper batchHelper = new ReportsBatchHelper();
    private final DataSyncHelper dataSyncHelper = new DataSyncHelper();
    public static String ACTION_DATA_SENDING = "MOE_ACTION_DATA_SENDING";
    private static final int APP_CLOSE_DATA_SYNC_JOB_ID = 90001;
    private static final int APP_CLOSE_DATA_SYNC_ALARM_ID = 90002;
    public static final int BACKGROUND_DATA_SYNC_JOB_ID = 90003;
    public static final int BACKGROUND_DATA_SYNC_ALARM_ID = 90004;
    public static final int IMMEDIATE_RETRY_DATA_SYNC_JOB_ID = 90005;
    public static final int IMMEDIATE_RETRY_DATA_SYNC_ALARM_ID = 90006;
    public static final int BATCH_SIZE = 100;
    public static int MAX_TEST_DEVICE_TIME = 60;
    public static int INTERVAL_RETRY_ONE = 60;
    public static int INTERVAL_RETRY_TWO = 180;
    public static int APP_CLOSE_SYNC_INTERVAL = 3;
    public static String ATTEMPT_NUMBER = "attempt_number";
    public static final int NO_RETRY = -1;
    public static final int RETRY_ONE = 1;
    public static final int RETRY_TWO = 2;
    private static final int EXPONENTIAL_COUNTER_LATENCY_RETRY = 2;

    private DataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataManager getInstance() {
        if (instance != null) return instance;
        Class<DataManager> clazz = DataManager.class;
        synchronized (DataManager.class) {
            if (instance != null) return instance;
            instance = new DataManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void scheduleDataSending(@NonNull Context context) {
        if (context == null) {
            Logger.v("Core_DataManagerscheduleDataSending() : context is null");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT < 21) {
                this.scheduleDataSendingAlarm(context, 90002, APP_CLOSE_SYNC_INTERVAL);
            } else {
                this.scheduleDataSendingJob(context, 90001, APP_CLOSE_SYNC_INTERVAL, 1);
            }
            this.scheduleBackgroundSyncIfRequired(context);
        }
        catch (Exception e) {
            Logger.e("Core_DataManagerscheduleDataSending() :  Exception: ", e);
        }
    }

    void scheduleImmediateRetry(Context context, int seconds, int attemptNumber) {
        Logger.v("Core_DataManager scheduleImmediateRetry() : Scheduling immediate retry, delay: " + seconds);
        if (Build.VERSION.SDK_INT < 21) {
            this.scheduleDataSendingAlarm(context, 90006, seconds);
        } else {
            this.scheduleDataSendingJob(context, 90005, seconds, attemptNumber);
        }
    }

    public void backgroundSync(Context context, int attemptNumber, MoEJobParameters jobParameters) {
        Logger.v("Core_DataManager backgroundSync() : ");
        this.queueBatchingDataTask(context, jobParameters, attemptNumber);
        this.scheduleBackgroundSyncIfRequired(context);
    }

    private void scheduleBackgroundSyncIfRequired(Context context) {
        if (!SdkConfig.getConfig().isBackgroundSyncEnabled) {
            return;
        }
        long syncInterval = RemoteConfig.getConfig().dataSyncRetryInterval / 1000L;
        Logger.v("Core_DataManager scheduleBackgroundSyncIfRequired() : Will schedule background sync.");
        if (Build.VERSION.SDK_INT < 21) {
            this.scheduleDataSendingAlarm(context, 90004, syncInterval);
        } else {
            this.scheduleDataSendingJob(context, 90003, syncInterval, 1);
        }
        Logger.v("Core_DataManager scheduleBackgroundSyncIfRequired() : Background sync scheduled.");
    }

    private void scheduleDataSendingAlarm(@NonNull Context context, int alarmId, long syncInterval) {
        Logger.v("Core_DataManager scheduleDataSending() alarmId: " + alarmId + " interval: " + syncInterval);
        Intent alarmIntent = new Intent(context, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)alarmId, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, MoEUtils.secondsToMillis(MoEUtils.currentSeconds() + syncInterval), pendingIntent);
        }
    }

    @TargetApi(value=21)
    private void scheduleDataSendingJob(@NonNull Context context, int jobId, long syncInterval, int attemptNumber) {
        Logger.v("Core_DataManager scheduleDataSendingJob() JobId: " + jobId + " interval: " + syncInterval);
        ComponentName serviceComponent = new ComponentName(context, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(jobId, serviceComponent);
        builder.setRequiredNetworkType(1).setOverrideDeadline(MoEUtils.secondsToMillis(syncInterval * 2L)).setMinimumLatency(MoEUtils.secondsToMillis(syncInterval));
        PersistableBundle bundle = new PersistableBundle();
        bundle.putInt(ATTEMPT_NUMBER, attemptNumber);
        builder.setExtras(bundle);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void batchAndSyncData(Context context) {
        Logger.v("Core_DataManager batchAndSyncData() : Will batch and sync data");
        int attemptNumber = -1;
        if (!MoEngage.isAppForeground()) {
            attemptNumber = 1;
        }
        this.queueBatchingDataTask(context, null, attemptNumber);
    }

    private void queueBatchingDataTask(Context context, MoEJobParameters jobParameters, int attemptNumber) {
        Logger.v("Core_DataManager queueBatchingDataTask() : Will queue batching data task.");
        TaskManager.getInstance().addTaskToQueue(new BatchDataTask(context, true, jobParameters, attemptNumber));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void batchData(Context context) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            Logger.v("Core_DataManager batchData() : Cannot process this request on MAIN THREAD.");
            return;
        }
        Logger.v("Core_DataManager batchData() : Will batch data points.");
        this.batchHelper.createAndSaveBatches(context, AnalyticsHelper.getInstance(context).getSession());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void sendData(Context context, String appId, int attemptNumber) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            Logger.v("Core_DataManager sendData() : Cannot process this request on MAIN THREAD.");
            return;
        }
        if (MoEUtils.isEmptyString(appId)) {
            Logger.w("Core_DataManager sendData() : App-id is empty cannot send data");
            return;
        }
        Logger.v("Core_DataManager sendData() : Will send data to server.");
        this.dataSyncHelper.syncData(context, appId, attemptNumber);
    }
}

