/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.reports;

import android.content.Context;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.events.MoEEventManager;
import com.moengage.core.internal.reports.DataManager;
import com.moengage.core.internal.reports.SendInteractionDataTask;
import com.moengage.core.model.MoEJobParameters;

class BatchDataTask
extends SDKTask {
    private static final String TAG = "Core_BatchDataTask";
    private boolean shouldSyncData = false;
    private MoEJobParameters jobParameters;
    private int attemptNumber;

    public BatchDataTask(Context context) {
        this(context, false, null, -1);
    }

    public BatchDataTask(Context context, boolean shouldSyncData, MoEJobParameters jobParameters, int attemptNumber) {
        super(context);
        this.shouldSyncData = shouldSyncData;
        this.jobParameters = jobParameters;
        this.attemptNumber = attemptNumber;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("Core_BatchDataTask execute() : executing task.");
            DataManager.getInstance().batchData(this.context);
            MoEEventManager.getInstance(this.context).setEventCounter(0);
            if (this.shouldSyncData) {
                TaskManager.getInstance().startTask(new SendInteractionDataTask(this.context, this.jobParameters, this.attemptNumber));
            }
            Logger.v("Core_BatchDataTask execute() : Completed task.");
        }
        catch (Exception e) {
            Logger.e("Core_BatchDataTask execute() : ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "BATCH_DATA";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

