/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.remoteconfig;

import android.content.Context;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.RemoteConfigParser;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.storage.StorageProvider;
import com.moengage.core.rest.Response;
import org.json.JSONObject;

class RemoteConfigResponseHandler {
    private static final String TAG = "Core_RemoteConfigResponseHandler";

    RemoteConfigResponseHandler() {
    }

    boolean handleConfigApiResponse(Context context, @Nullable Response response) {
        try {
            if (response == null || response.responseCode != 200) {
                return false;
            }
            if (MoEUtils.isEmptyString(response.responseBody)) {
                return false;
            }
            RemoteConfig remoteConfig = RemoteConfigParser.fromJson(new JSONObject(response.responseBody));
            if (remoteConfig != null) {
                MoEDAO.getInstance(context).addOrUpdateRemoteConfiguration(response.responseBody);
                RemoteConfig.setRemoteConfig(remoteConfig);
            }
            StorageProvider.INSTANCE.getRepository(context, SdkConfig.getConfig()).updateConfigApiSyncTime(MoEUtils.currentMillis());
            return true;
        }
        catch (Exception e) {
            Logger.e("Core_RemoteConfigResponseHandler handleConfigApiResponse() : ", e);
            return false;
        }
    }
}

