/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.logger;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.logger.LogAdapter;

public class LogcatLogAdapter
implements LogAdapter {
    @Override
    public boolean isLoggable(int logLevel, String logTag) {
        return (SdkConfig.getConfig().logConfig.isEnabledForSignedBuild || MoEngage.isDebugBuild()) && SdkConfig.getConfig().logConfig.level >= logLevel;
    }

    @Override
    public void log(int logLevel, @Nullable String tag, @NonNull String message, @Nullable Throwable throwable) {
        try {
            if (MoEUtils.isEmptyString(message)) {
                return;
            }
            switch (logLevel) {
                case 5: {
                    this.logVerbose(tag, message);
                    break;
                }
                case 4: {
                    this.logDebug(tag, message);
                    break;
                }
                case 2: {
                    Log.w((String)tag, (String)message);
                    break;
                }
                case 1: {
                    if (throwable != null) {
                        Log.e((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    Log.e((String)tag, (String)message);
                    break;
                }
                case 3: {
                    Log.i((String)tag, (String)message);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logVerbose(String tag, String message) {
        if (message.length() > 4000) {
            Log.d((String)tag, (String)message.substring(0, 4000));
            this.logVerbose(tag, message.substring(4000));
        } else {
            Log.d((String)tag, (String)message);
        }
    }

    private void logDebug(String tag, String message) {
        if (message.length() > 4000) {
            Log.d((String)tag, (String)message.substring(0, 4000));
            this.logDebug(tag, message.substring(4000));
        } else {
            Log.d((String)tag, (String)message);
        }
    }
}

