/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.HashMap;

public class LogUtils {
    public static HashMap<String, Integer> LOG_TYPE_TO_LEVEL_MAPPING = new HashMap();
    public static HashMap<Integer, String> LOG_LEVEL_TO_LOG_TYPE_MAPPING = new HashMap();
    public static final String LOG_LEVEL_NO_LOG = "no_log";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_VERBOSE = "verbose";

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static boolean isValidLevel(int level) {
        return level >= 0 && level <= 5;
    }

    static {
        LOG_TYPE_TO_LEVEL_MAPPING.put(LOG_LEVEL_NO_LOG, 0);
        LOG_TYPE_TO_LEVEL_MAPPING.put(LOG_LEVEL_ERROR, 1);
        LOG_TYPE_TO_LEVEL_MAPPING.put(LOG_LEVEL_WARN, 2);
        LOG_TYPE_TO_LEVEL_MAPPING.put(LOG_LEVEL_INFO, 3);
        LOG_TYPE_TO_LEVEL_MAPPING.put(LOG_LEVEL_DEBUG, 4);
        LOG_TYPE_TO_LEVEL_MAPPING.put(LOG_LEVEL_VERBOSE, 5);
        LOG_LEVEL_TO_LOG_TYPE_MAPPING.put(0, LOG_LEVEL_NO_LOG);
        LOG_LEVEL_TO_LOG_TYPE_MAPPING.put(1, LOG_LEVEL_ERROR);
        LOG_LEVEL_TO_LOG_TYPE_MAPPING.put(2, LOG_LEVEL_WARN);
        LOG_LEVEL_TO_LOG_TYPE_MAPPING.put(3, LOG_LEVEL_INFO);
        LOG_LEVEL_TO_LOG_TYPE_MAPPING.put(4, LOG_LEVEL_DEBUG);
        LOG_LEVEL_TO_LOG_TYPE_MAPPING.put(5, LOG_LEVEL_VERBOSE);
    }
}

