/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.logger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.internal.logger.LogAdapter;
import com.moengage.core.internal.logger.LogUtils;
import com.moengage.core.internal.logger.Printer;
import java.util.HashSet;
import java.util.Set;

public class LogPrinter
implements Printer {
    private final Set<LogAdapter> logAdapters = new HashSet<LogAdapter>();
    private String tag = "MoEngage_v10500";

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public void addAdapter(@NonNull LogAdapter logAdapter) {
        try {
            if (logAdapter != null) {
                this.logAdapters.add(logAdapter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeAdapter(@NonNull LogAdapter logAdapter) {
        if (logAdapter != null) {
            this.logAdapters.remove(logAdapter);
        }
    }

    @Override
    public void clearAllAdapters() {
        this.logAdapters.clear();
    }

    @Override
    public void v(String message, @Nullable Throwable throwable) {
        this.log(5, this.tag, message, throwable);
    }

    @Override
    public void d(String message, @Nullable Throwable throwable) {
        this.log(4, this.tag, message, throwable);
    }

    @Override
    public void w(String message, @Nullable Throwable throwable) {
        this.log(2, this.tag, message, throwable);
    }

    @Override
    public void e(String message, @Nullable Throwable throwable) {
        this.log(1, this.tag, message, throwable);
    }

    @Override
    public void i(String message, @Nullable Throwable throwable) {
        this.log(3, this.tag, message, throwable);
    }

    @Override
    public void log(int logLevel, String tag, String message, @Nullable Throwable throwable) {
        try {
            for (LogAdapter logAdapter : this.logAdapters) {
                if (!logAdapter.isLoggable(logLevel, tag)) continue;
                if (throwable != null) {
                    message = message + " : " + LogUtils.getStackTraceString(throwable);
                }
                logAdapter.log(logLevel, tag, message, throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

