/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.location;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.location.LocationHandler;

public final class GeoManager {
    private static final String TAG = "Core_GeoManager";
    private LocationHandler handler;
    private static GeoManager instance;

    private GeoManager() {
        this.loadHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeoManager getInstance() {
        if (instance != null) return instance;
        Class<GeoManager> clazz = GeoManager.class;
        synchronized (GeoManager.class) {
            if (instance != null) return instance;
            instance = new GeoManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadHandler() {
        try {
            this.handler = (LocationHandler)Class.forName("com.moengage.geofence.internal.LocationHandlerImpl").newInstance();
        }
        catch (Exception e) {
            Logger.v("Core_GeoManager loadHandler() : Geofence module not found.");
        }
    }

    @Nullable
    public LocationHandler getHandler(@NonNull Context context) {
        if (null == context) {
            return null;
        }
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return null;
        }
        if (SdkConfig.getConfig().isLocationServiceEnabled) {
            return this.handler;
        }
        return null;
    }

    public void updateFenceAndLocation(Context context) {
        LocationHandler handler = this.getHandler(context);
        if (handler != null) {
            handler.updateFenceAndLocation(context);
        }
    }

    public void removeGeoFences(Context context) {
        if (this.handler != null) {
            this.handler.removeGeoFences(context);
        }
    }

    public void scheduleBackgroundSync(Context context) {
        LocationHandler handler = this.getHandler(context);
        if (handler != null) {
            handler.scheduleBackgroundSync(context);
        }
    }
}

