/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.inapp;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.RemoteConfig;
import com.moengage.core.internal.inapp.InAppHandler;
import com.moengage.core.model.InAppV2Meta;
import com.moengage.core.model.InAppV3Meta;

public class InAppManager {
    private static final String TAG = "Core_InAppManager";
    private InAppHandler inAppHandler;
    private static InAppManager instance;

    private InAppManager() {
        this.loadInAppHandler();
    }

    private void loadInAppHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.inapp.InAppHandlerImpl");
            this.inAppHandler = (InAppHandler)handler.newInstance();
            Logger.v("InAppManager:loadInAppHandler InApp Module present");
        }
        catch (Exception e) {
            Logger.v("Core_InAppManager loadInAppHandler : InApp Module not present ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InAppManager getInstance() {
        if (instance != null) return instance;
        Class<InAppManager> clazz = InAppManager.class;
        synchronized (InAppManager.class) {
            if (instance != null) return instance;
            instance = new InAppManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void showInAppIfRequired(Context context) {
        if (this.isInAppModuleActive(context)) {
            this.inAppHandler.showInAppIfRequired(context);
        }
    }

    public void registerInAppManager(Activity activity) {
        if (this.isInAppModuleActive(activity.getApplicationContext())) {
            this.inAppHandler.registerInAppManager(activity);
        }
    }

    public void unregisterInAppManager(Activity activity) {
        if (this.isInAppModuleActive(activity.getApplicationContext())) {
            this.inAppHandler.unregisterInAppManager(activity);
        }
    }

    public void showTriggerInAppIfPossible(Context context, Event action) {
        if (this.isInAppModuleActive(context)) {
            this.inAppHandler.showTriggerInAppIfPossible(context, action);
        }
    }

    public void onLogout(Context context) {
        if (this.inAppHandler != null) {
            this.inAppHandler.onLogout(context);
        }
    }

    public void onAppClose(Context context) {
        if (this.inAppHandler != null) {
            this.inAppHandler.onAppClose(context);
        }
    }

    private boolean isInAppModuleActive(Context context) {
        RemoteConfig config = RemoteConfig.getConfig();
        return this.inAppHandler != null && !ConfigurationProvider.getInstance(context).isInAppOptedOut() && config.isInAppEnabled && config.isAppEnabled;
    }

    public void syncInAppsIfRequired(Context context) {
        if (this.isInAppModuleActive(context)) {
            this.inAppHandler.syncInAppIfRequired(context);
        }
    }

    public void showInAppFromPush(Context context, Bundle pushPayload) {
        if (this.isInAppModuleActive(context)) {
            this.inAppHandler.showInAppFromPush(context, pushPayload);
        }
    }

    @Nullable
    public InAppV3Meta generateMetaForV2Campaign(InAppV2Meta inAppV2Meta) {
        if (this.inAppHandler != null) {
            return this.inAppHandler.generateMetaForV2Campaign(inAppV2Meta);
        }
        return null;
    }
}

