/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.events;

import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.Properties;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONObject;

class EventHandler {
    private static final String TAG = "Core_EventHandler";

    EventHandler() {
    }

    Event transformToEventModel(String eventName, JSONObject attributes) {
        if (attributes != null && (attributes.has("EVENT_ATTRS") || attributes.has("EVENT_ATTRS_CUST")) && attributes.has("EVENT_L_TIME") && attributes.has("EVENT_G_TIME")) {
            return new Event(eventName, attributes);
        }
        Properties properties = new Properties();
        if (attributes != null) {
            Iterator iterator = attributes.keys();
            while (iterator.hasNext()) {
                try {
                    String key = (String)iterator.next();
                    properties.addAttribute(key, attributes.get(key));
                }
                catch (Exception e) {
                    Logger.e("Core_EventHandler trackEvent() : Exception ", e);
                }
            }
        }
        return new Event(eventName, properties.getPayload().build());
    }

    boolean shouldTrackEvent(boolean isDataTrackingOptedOut, Set<String> gdprWhitelistEvent, Set<String> blackListEvents, String eventName) {
        if (isDataTrackingOptedOut) {
            if (gdprWhitelistEvent == null) {
                return false;
            }
            return gdprWhitelistEvent.contains(eventName);
        }
        if (blackListEvents == null) {
            return true;
        }
        return !blackListEvents.contains(eventName);
    }
}

