/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal.analytics;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.RemoteConfig;
import com.moengage.core.internal.analytics.SourceProcessor;
import com.moengage.core.internal.reports.DataManager;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.model.UserSession;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnalyticsHelper {
    private static final String TAG = "Core_AnalyticsHelper";
    private static AnalyticsHelper instance = null;
    private UserSession session;
    private MoECoreEvaluator evaluator;
    private boolean hasProcessedAppOpen;
    private final Object lock = new Object();
    public static final int MAX_INTERVAL_FOR_SOURCE_UPDATE = 3;

    private AnalyticsHelper(Context context) {
        this.session = MoEDAO.getInstance(context).getLastSavedSession();
        this.evaluator = new MoECoreEvaluator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<AnalyticsHelper> clazz = AnalyticsHelper.class;
        synchronized (AnalyticsHelper.class) {
            if (instance != null) return instance;
            instance = new AnalyticsHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void onEventTracked(Event event, Context context) {
        try {
            Logger.v("Core_AnalyticsHelper onEventTracked() : Will update last interaction time if required. Event: " + event.details);
            if (!event.isInteractiveEvent) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : No operation required. Tracked event is non-interactive");
                return;
            }
            if ("EVENT_ACTION_USER_ATTRIBUTE".equals(event.eventName)) {
                Logger.v("Core_AnalyticsHelper updateSession() : Need not update session info since user attribute is tracked.");
                return;
            }
            if (!this.hasProcessedAppOpen && this.evaluator.hasSessionExpired(this.session == null ? 0L : this.session.lastInteractionTime, RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentMillis())) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : Source not processed yet. Will create new session");
                this.batchPreviousDataAndCreateNewSession(context, null);
                return;
            }
            if (MoEngage.isAppForeground()) {
                Logger.v("Core_AnalyticsHelper updateSession() : App is in foreground no action required.");
                return;
            }
            if (this.session == null) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : No previous session. Will create a new session");
                this.batchPreviousDataAndCreateNewSession(context, null);
                return;
            }
            if (this.evaluator.hasSessionExpired(this.session.lastInteractionTime, RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentMillis())) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : Session has expired.");
                this.batchPreviousDataAndCreateNewSession(context, null);
                return;
            }
            this.updateLastInteractionTime(MoEUtils.currentMillis());
        }
        catch (Exception e) {
            Logger.e("Core_AnalyticsHelper onEventTracked() : Exception: ", e);
        }
    }

    void updateLastInteractionTime(long time) {
        if (this.session != null) {
            this.session.lastInteractionTime = time;
        }
    }

    @WorkerThread
    public void onActivityStart(Activity activity) {
        Logger.v("Core_AnalyticsHelper onActivityStart() : Will try to process traffic information.");
        if (this.session != null) {
            Logger.v("Core_AnalyticsHelper onActivityStart() : Existing Session " + this.session.toString());
        }
        if (this.hasProcessedAppOpen) {
            Logger.v("Core_AnalyticsHelper onActivityStart() : App Open already processed. Ignoring");
            return;
        }
        this.updateUserSessionIfRequired(activity);
        this.hasProcessedAppOpen = true;
    }

    public void onNotificationClicked(Context context, TrafficSource source) {
        try {
            Logger.v("Core_AnalyticsHelper onNotificationClicked() : Source " + source);
            this.updateSessionIfRequired(context, source);
        }
        catch (Exception e) {
            Logger.e("Core_AnalyticsHelper onNotificationClicked() : ", e);
        }
    }

    private void updateUserSessionIfRequired(Activity activity) {
        try {
            Logger.v("Core_AnalyticsHelper updateUserSessionIfRequired() : ");
            Context context = activity.getApplicationContext();
            SourceProcessor sourceProcessor = new SourceProcessor();
            TrafficSource computedSource = sourceProcessor.getTrafficSourceFromActivity(activity, RemoteConfig.getConfig().additionalSourceIdentifiers);
            Logger.v("Core_AnalyticsHelper updateUserSessionIfRequired() : Computed Source " + computedSource);
            this.updateSessionIfRequired(context, computedSource);
        }
        catch (Exception e) {
            Logger.e("Core_AnalyticsHelper onAppOpen() : Exception: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionIfRequired(Context context, TrafficSource currentSource) {
        Object object = this.lock;
        synchronized (object) {
            Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : New source: " + currentSource);
            if (this.session == null) {
                Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : No saved session for user will create a new session.");
                this.batchPreviousDataAndCreateNewSession(context, currentSource);
                return;
            }
            Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Current Session: " + this.session);
            if (this.evaluator.canUpdateSourceInCurrentSession(this.session, MoEUtils.currentMillis())) {
                Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Updating Traffic source.");
                this.session.trafficSource = currentSource;
                Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Updated session: " + this.session);
                return;
            }
            Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Cannot update existing session, will create a new session if required.");
            boolean hasSessionExpired = this.evaluator.hasSessionExpired(this.session.lastInteractionTime, RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentMillis());
            if (hasSessionExpired) {
                Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Previous session has expired. Will create a new session");
                this.batchPreviousDataAndCreateNewSession(context, currentSource);
                return;
            }
            TrafficSource savedSource = this.session.trafficSource;
            boolean hasSourceChanged = this.evaluator.hasSourceChanged(savedSource, currentSource);
            if (hasSourceChanged) {
                Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Source changed. will create a new session");
                this.batchPreviousDataAndCreateNewSession(context, currentSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void batchPreviousDataAndCreateNewSession(Context context, TrafficSource currentSource) {
        Object object = this.lock;
        synchronized (object) {
            Logger.v("Core_AnalyticsHelper batchPreviousDataAndCreateNewSession() : Will try to batch data and create new session");
            DataManager.getInstance().batchData(context);
            this.createAndPersistNewSession(context, currentSource);
        }
    }

    private UserSession createAndPersistNewSession(Context context, TrafficSource currentSource) {
        this.session = this.createNewSession(currentSource);
        Logger.v("Core_AnalyticsHelper createAndPersistNewSession() : New session: " + this.session.toString());
        this.persistUserSession(context, this.session);
        return this.session;
    }

    private UserSession createNewSession(@Nullable TrafficSource currentSource) {
        long currentTime = MoEUtils.currentMillis();
        return new UserSession(UUID.randomUUID().toString(), MoEUtils.getTimeInISO(currentTime), currentSource, currentTime);
    }

    private void persistUserSession(Context context, UserSession userSession) {
        MoEDAO.getInstance(context).saveUserSession(userSession);
    }

    public void onAppClose(Context context) {
        Logger.v("Core_AnalyticsHelper onAppClose() : ");
        this.hasProcessedAppOpen = false;
        this.updateLastInteractionTime(MoEUtils.currentMillis());
        this.persistUserSession(context, this.session);
    }

    @WorkerThread
    public void onLogout(Context context) {
        this.createAndPersistNewSession(context, null);
    }

    @Nullable
    public UserSession getSession() {
        return this.session;
    }
}

