/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

public class MoEWorkerTask
extends SDKTask {
    private String workerTaskType;
    private Bundle extras;

    public MoEWorkerTask(Context context, @NonNull String workerTaskType, @Nullable Bundle extras) {
        super(context);
        this.workerTaskType = workerTaskType;
        this.extras = extras;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("MoEWorkerTask: executing task");
            if (TextUtils.isEmpty((CharSequence)this.workerTaskType)) {
                return null;
            }
            switch (this.workerTaskType) {
                case "APP_UPDATE": {
                    MoEDispatcher.getInstance(this.context).handleAppUpdateEvent();
                    break;
                }
                case "LOGOUT": {
                    MoEDispatcher.getInstance(this.context).handleLogout(this.extras.getBoolean("IS_FORCE_LOGOUT", false));
                    break;
                }
                default: {
                    Logger.v("Not a valid task type");
                }
            }
            Logger.v("MoEWorkerTask: completed task");
        }
        catch (Exception e) {
            Logger.e("MoEWorkerTask: execute() ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "MOE_WORKER_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

