/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.internal;

import android.content.Context;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.RemoteConfig;
import com.moengage.core.RemoteConfigParser;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Set;
import org.json.JSONObject;

public class LoadConfigurationFromDiskTask
extends SDKTask {
    private static final String TAG = "Core_LoadConfigurationFromDiskTask";

    public LoadConfigurationFromDiskTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        try {
            this.loadRemoteConfigFromDisk();
        }
        catch (Exception e) {
            Logger.e("Core_LoadConfigurationFromDiskTask execute() : ", e);
        }
        return this.taskResult;
    }

    private void loadRemoteConfigFromDisk() {
        try {
            RemoteConfig storedConfig;
            String configurationString = ConfigurationProvider.getInstance(this.context).getRemoteConfiguration();
            RemoteConfig configuration = new RemoteConfig();
            if (configurationString != null && (storedConfig = RemoteConfigParser.fromJson(new JSONObject(configurationString))) != null) {
                configuration = storedConfig;
            }
            RemoteConfig.setRemoteConfig(configuration);
            Set<String> savedScreenNames = ConfigurationProvider.getInstance(this.context).getSentScreenNames();
            if (savedScreenNames != null) {
                ConfigurationCache.getInstance().initialiseSentScreens(savedScreenNames);
            }
            if (ConfigurationProvider.getInstance(this.context).isDebugLogEnabled()) {
                SdkConfig.getConfig().logConfig.isEnabledForSignedBuild = true;
                SdkConfig.getConfig().logConfig.level = 5;
            }
            Logger.v("Core_LoadConfigurationFromDiskTask loadRemoteConfigFromDisk() : Config: " + RemoteConfig.getConfig().toString());
        }
        catch (Exception e) {
            Logger.e("Core_LoadConfigurationFromDiskTask loadRemoteConfigFromDisk() : Exception ", e);
        }
    }

    @Override
    public String getTaskTag() {
        return "LOAD_CONFIGURATION_FROM_DISK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

