/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.integrations.segment;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Iterator;
import org.json.JSONObject;

public class TrackSegmentEventTask
extends SDKTask {
    private String eventName;
    private JSONObject eventAttributes;
    private static final String TAG = "Core_TrackSegmentEventTask";

    public TrackSegmentEventTask(Context context, String eventName, JSONObject eventAttributes) {
        super(context);
        this.eventName = eventName;
        this.eventAttributes = eventAttributes;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("Core_TrackSegmentEventTask execute() : Started Execution");
            Properties properties = this.transformEventAttributesToMoEngageFormat(this.eventAttributes);
            if (properties == null) {
                Logger.w("Core_TrackSegmentEventTask execute() : Could not parse segment payload.");
                return this.taskResult;
            }
            MoEHelper.getInstance(this.context).trackEvent(this.eventName, properties);
            Logger.v("Core_TrackSegmentEventTask execute() : Completed Execution");
            this.taskResult.setIsSuccess(true);
        }
        catch (Exception e) {
            Logger.e("Core_TrackSegmentEventTask execute() : Exception: ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "TRACK_EVENT_SEGMENT";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private Properties transformEventAttributesToMoEngageFormat(JSONObject eventAttributes) {
        try {
            Logger.v("Core_TrackSegmentEventTask transformEventAttributesToMoEngageFormat() : Transforming track properties  to MoEngage format");
            Properties properties = new Properties();
            Iterator iterator = eventAttributes.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = eventAttributes.get(key);
                if (value instanceof String) {
                    if (!MoEUtils.isDate((String)value)) {
                        properties.addAttribute(key, value);
                        continue;
                    }
                    properties.addDateIso(key, (String)value);
                    continue;
                }
                properties.addAttribute(key, value);
            }
            return properties;
        }
        catch (Exception e) {
            Logger.e("Core_TrackSegmentEventTask transformEventAttributesToMoEngageFormat() : ", e);
            return null;
        }
    }
}

