/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.events.MoEEventManager;
import com.moengage.core.model.MoEAttribute;
import org.json.JSONObject;

class SetAliasTask
extends SDKTask {
    private static final String TAG = "Core_SetAliasTask";
    private JSONObject aliasJSON;

    SetAliasTask(Context context, JSONObject aliasJSON) {
        super(context);
        this.aliasJSON = aliasJSON;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("SetAliasTask: executing alias task");
            MoEAttribute aliasAttribute = MoEUtils.convertJsonToAttributeObject(this.aliasJSON);
            String savedUniqueId = MoEUtils.getUserAttributeUniqueId(this.context);
            if (savedUniqueId == null || aliasAttribute == null) {
                MoEHelper.getInstance(this.context).getAttributeManager().setUserAttribute(this.aliasJSON);
                return null;
            }
            if (savedUniqueId.equals(aliasAttribute.getValue())) {
                Logger.v("Core_SetAliasTask execute() current unique id same as same existing no need to update");
                return null;
            }
            MoECoreEvaluator evaluator = new MoECoreEvaluator();
            if (!evaluator.isValidUniqueId(RemoteConfig.getConfig().blockedUniqueIdRegex, aliasAttribute.getValue())) {
                Logger.w("Core_SetAliasTask execute() : Not a valid unique id. Tracked Value: " + aliasAttribute.getValue());
                return null;
            }
            MoEDAO.getInstance(this.context).saveUserAttributeUniqueId(aliasAttribute);
            this.aliasJSON.put("USER_ID_MODIFIED_FROM", (Object)savedUniqueId);
            Event event = new Event("EVENT_ACTION_USER_ATTRIBUTE", this.aliasJSON);
            MoEEventManager.getInstance(this.context).writeDataPointToStorage(event);
            Logger.v("Core_SetAliasTask completed alias task");
        }
        catch (Exception e) {
            Logger.v("Core_SetAliasTask execute() ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "SET_ALIAS";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

