/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import androidx.annotation.Nullable;
import com.moengage.core.DataCenter;
import com.moengage.core.MoEConstants;
import com.moengage.core.config.CardConfig;
import com.moengage.core.config.LogConfig;
import com.moengage.core.config.PushConfig;
import com.moengage.core.config.TrackingOptOutConfig;
import java.util.List;

public class SdkConfig {
    public String appId;
    @Nullable
    public List<String> inAppOptOutList;
    @Nullable
    public List<String> activityTrackingOptOutList;
    public boolean isNavBarOptedOut;
    public boolean isGaidTrackingOptedOut;
    public boolean isLocationTrackingOptedOut;
    public boolean isGeofenceTrackingOptedOut;
    public DataCenter dataCenter = DataCenter.DATA_CENTER_1;
    public long flushInterval = -1L;
    public boolean isPeriodicFlushEnabled = true;
    public boolean isLocationServiceEnabled;
    public boolean isBackgroundSyncEnabled = true;
    public boolean isRealTimeTriggerBackgroundSyncEnabled = true;
    public boolean isSegmentIntegration;
    public boolean isLifecycleInAppOptedOut;
    public boolean isBackgroundLocationFetchEnabled;
    public boolean isGeofenceBackgroundSyncEnabled = true;
    public CardConfig cardConfig;
    public PushConfig pushConfig;
    public LogConfig logConfig;
    public TrackingOptOutConfig trackingOptOut;
    public boolean isEncryptionEnabled;
    private static SdkConfig sdkConfig;

    public SdkConfig(String appId) {
        this.appId = appId;
        this.cardConfig = new CardConfig(-1, -1, MoEConstants.CARD_DEFAULT_DATE_FORMAT);
        this.pushConfig = new PushConfig();
        this.logConfig = new LogConfig();
        this.trackingOptOut = new TrackingOptOutConfig(false, false, false, false);
    }

    SdkConfig() {
        this(null);
    }

    public String toString() {
        return "{\n\"appId\": \"" + this.appId + "\" ,\n \"inAppOptOutList\": " + this.inAppOptOutList + ",\n \"activityTrackingOptOutList\": " + this.activityTrackingOptOutList + ",\n \"isNavBarOptedOut\": " + this.isNavBarOptedOut + ",\n \"isLocationTrackingOptedOut\": " + this.isLocationTrackingOptedOut + ",\n \"isGeofenceTrackingOptedOut\": " + this.isGeofenceTrackingOptedOut + ",\n \"dataRegion\": " + (Object)((Object)this.dataCenter) + ",\n \"flushInterval\": " + this.flushInterval + ",\n \"isPeriodicFlushEnabled\": " + this.isPeriodicFlushEnabled + ",\n \"isLocationServiceEnabled\": " + this.isLocationServiceEnabled + ",\n \"isBackgroundSyncEnabled\": " + this.isBackgroundSyncEnabled + ",\n \"isRealTimeTriggerBackgroundSyncEnabled\": " + this.isRealTimeTriggerBackgroundSyncEnabled + ",\n \"isSegmentIntegration\": " + this.isSegmentIntegration + ",\n \"isLifecycleInAppOptedOut\": " + this.isLifecycleInAppOptedOut + ",\n \"isBackgroundLocationFetchEnabled\": " + this.isBackgroundLocationFetchEnabled + ",\n \"isGeofenceBackgroundSyncEnabled\": " + this.isGeofenceBackgroundSyncEnabled + ",\n \"cardConfig\": " + this.cardConfig + ",\n \"pushConfig\": " + this.pushConfig + ",\n \"isEncryptionEnabled\": " + this.isEncryptionEnabled + ",\n \"logConfig\": " + this.logConfig + ",\n \"trackingOptOut\": " + this.trackingOptOut + "\n" + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdkConfig getConfig() {
        if (sdkConfig != null) return sdkConfig;
        Class<SdkConfig> clazz = SdkConfig.class;
        synchronized (SdkConfig.class) {
            if (sdkConfig != null) return sdkConfig;
            sdkConfig = new SdkConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sdkConfig;
        }
    }

    static void setSdkConfig(SdkConfig config) {
        sdkConfig = config;
    }
}

