/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import androidx.annotation.Nullable;
import com.moengage.core.RemoteConfigDefault;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemoteConfig {
    public long pushAmpSyncDelay = RemoteConfigDefault.PUSH_AMP_SYNC_INTERVAL;
    @Nullable
    public Set<String> blacklistedEvents;
    public boolean isAppEnabled = RemoteConfigDefault.ACCOUNT_STATUS;
    public boolean isInAppEnabled = RemoteConfigDefault.IN_APP_STATUS;
    public boolean isGeofenceEnabled = RemoteConfigDefault.GEO_FENCE_STATUS;
    public boolean isPushAmpEnabled = RemoteConfigDefault.PUSH_AMP_STATUS;
    public int eventBatchCount = RemoteConfigDefault.EVENT_BATCH_COUNT;
    public long dataSyncRetryInterval = RemoteConfigDefault.DATA_SYNC_RETRY_INTERVAL;
    public Set<String> flushEvents;
    public boolean isPeriodicFlushEnabled = RemoteConfigDefault.PERIODIC_FLUSH_STATE;
    public long periodicFlushTime = RemoteConfigDefault.PERIODIC_FLUSH_TIME;
    public long pushAmpCampaignExpiryTime = RemoteConfigDefault.PUSH_AMP_CAMPAIGN_EXPIRY_TIME;
    public boolean isRealTimeTriggerEnabled = RemoteConfigDefault.REAL_TIME_TRIGGER_STATUS;
    public long realTimeTriggerBackgroundSyncInterval = RemoteConfigDefault.REAL_TIME_TRIGGER_SYNC_INTERVAL;
    public Set<String> gdprWhitelistEventList;
    public long userAttributeCachingTime = RemoteConfigDefault.USER_ATTRIBUTE_CACHING_TIME;
    @Nullable
    public List<String> blockedUniqueIdRegex;
    public long sessionInActiveTime = RemoteConfigDefault.DEFAULT_SESSION_INACTIVE_TIME;
    public Set<String> additionalSourceIdentifiers = new HashSet<String>();
    public boolean isPushAmpPlusEnabled;
    String encryptionKey;
    public int logLevel;
    public boolean isRemoteLoggingEnabled;
    private static RemoteConfig remoteConfig;

    public RemoteConfig() {
        this.flushEvents = new HashSet<String>();
        this.flushEvents.addAll(RemoteConfigDefault.DEFAULT_FLUSH_EVENTS);
        this.gdprWhitelistEventList = new HashSet<String>();
        this.gdprWhitelistEventList.addAll(RemoteConfigDefault.DEFAULT_GDPR_WHITELIST_EVENTS);
        this.isPushAmpPlusEnabled = RemoteConfigDefault.MI_PUSH_APP_STATUS;
        this.encryptionKey = RemoteConfigDefault.DEFAULT_DATA_ENCRYPTION_KEY;
        this.isRemoteLoggingEnabled = RemoteConfigDefault.DEFAULT_REMOTE_LOGGING_STATE;
        this.logLevel = RemoteConfigDefault.DEFAULT_REMOTE_LOGGING_LEVEL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConfig that = (RemoteConfig)o;
        if (this.pushAmpSyncDelay != that.pushAmpSyncDelay) {
            return false;
        }
        if (this.isAppEnabled != that.isAppEnabled) {
            return false;
        }
        if (this.isInAppEnabled != that.isInAppEnabled) {
            return false;
        }
        if (this.isGeofenceEnabled != that.isGeofenceEnabled) {
            return false;
        }
        if (this.isPushAmpEnabled != that.isPushAmpEnabled) {
            return false;
        }
        if (this.eventBatchCount != that.eventBatchCount) {
            return false;
        }
        if (this.dataSyncRetryInterval != that.dataSyncRetryInterval) {
            return false;
        }
        if (this.isPeriodicFlushEnabled != that.isPeriodicFlushEnabled) {
            return false;
        }
        if (this.periodicFlushTime != that.periodicFlushTime) {
            return false;
        }
        if (this.pushAmpCampaignExpiryTime != that.pushAmpCampaignExpiryTime) {
            return false;
        }
        if (this.isRealTimeTriggerEnabled != that.isRealTimeTriggerEnabled) {
            return false;
        }
        if (this.realTimeTriggerBackgroundSyncInterval != that.realTimeTriggerBackgroundSyncInterval) {
            return false;
        }
        if (this.userAttributeCachingTime != that.userAttributeCachingTime) {
            return false;
        }
        if (this.sessionInActiveTime != that.sessionInActiveTime) {
            return false;
        }
        if (this.blacklistedEvents != null ? !this.blacklistedEvents.equals(that.blacklistedEvents) : that.blacklistedEvents != null) {
            return false;
        }
        if (this.flushEvents != null ? !this.flushEvents.equals(that.flushEvents) : that.flushEvents != null) {
            return false;
        }
        if (this.gdprWhitelistEventList != null ? !this.gdprWhitelistEventList.equals(that.gdprWhitelistEventList) : that.gdprWhitelistEventList != null) {
            return false;
        }
        return this.blockedUniqueIdRegex != null ? this.blockedUniqueIdRegex.equals(that.blockedUniqueIdRegex) : that.blockedUniqueIdRegex == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RemoteConfig getConfig() {
        if (remoteConfig != null) return remoteConfig;
        Class<RemoteConfig> clazz = RemoteConfig.class;
        synchronized (RemoteConfig.class) {
            if (remoteConfig != null) return remoteConfig;
            remoteConfig = new RemoteConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return remoteConfig;
        }
    }

    public static void setRemoteConfig(RemoteConfig config) {
        remoteConfig = config;
    }

    public String toString() {
        return "RemoteConfig{pushAmpSyncDelay=" + this.pushAmpSyncDelay + ", blacklistedEvents=" + this.blacklistedEvents + ", isAppEnabled=" + this.isAppEnabled + ", isInAppEnabled=" + this.isInAppEnabled + ", isGeofenceEnabled=" + this.isGeofenceEnabled + ", isPushAmpEnabled=" + this.isPushAmpEnabled + ", eventBatchCount=" + this.eventBatchCount + ", dataSyncRetryInterval=" + this.dataSyncRetryInterval + ", flushEvents=" + this.flushEvents + ", isPeriodicFlushEnabled=" + this.isPeriodicFlushEnabled + ", periodicFlushTime=" + this.periodicFlushTime + ", pushAmpCampaignExpiryTime=" + this.pushAmpCampaignExpiryTime + ", isRealTimeTriggerEnabled=" + this.isRealTimeTriggerEnabled + ", realTimeTriggerBackgroundSyncInterval=" + this.realTimeTriggerBackgroundSyncInterval + ", gdprWhitelistEventList=" + this.gdprWhitelistEventList + ", userAttributeCachingTime=" + this.userAttributeCachingTime + ", blockedUniqueIdRegex=" + this.blockedUniqueIdRegex + ", sessionInActiveTime=" + this.sessionInActiveTime + ", additionalSourceIdentifiers=" + this.additionalSourceIdentifiers + ", isPushAmpPlusEnabled=" + this.isPushAmpPlusEnabled + ", encryptionKey='" + this.encryptionKey + '\'' + ", logLevel=" + this.logLevel + ", isRemoteLoggingEnabled=" + this.isRemoteLoggingEnabled + '}';
    }
}

