/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.NonNull;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DataCenter;
import com.moengage.core.DataTrackingOptOutTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.config.CardConfig;
import com.moengage.core.config.FcmConfig;
import com.moengage.core.config.MiPushConfig;
import com.moengage.core.config.TrackingOptOutConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.internal.LoadConfigurationFromDiskTask;
import com.moengage.core.internal.logger.LogManager;
import com.moengage.core.internal.logger.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class MoEngage {
    private static final String TAG = "Core_MoEngage";
    private Builder builder;
    private static boolean isDebugBuild = false;
    static boolean isAppForeground = false;

    private MoEngage(Builder builder) {
        this.builder = builder;
    }

    public static boolean isDebugBuild() {
        return isDebugBuild;
    }

    static void setBuildStatus(boolean buildStatus) {
        isDebugBuild = buildStatus;
    }

    public static boolean isAppForeground() {
        return isAppForeground;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initialise(@NonNull MoEngage moEngage) {
        LogManager.getInstance().addLogcatAdapter();
        if (moEngage == null) {
            Logger.e("Core_MoEngage Object instance is null cannot initialise");
            return;
        }
        Builder builder = moEngage.builder;
        if (builder == null || builder.application == null) {
            Logger.e("Core_MoEngageinitialise() Builder/Context/Application is null. Cannot initialise SDK.");
            return;
        }
        Context context = builder.application.getApplicationContext();
        isDebugBuild = MoEUtils.isDebugBuild(context);
        Logger.setLogLevel(((Builder)builder).sdkConfig.logConfig.level);
        RemoteConfig.setRemoteConfig(new RemoteConfig());
        TaskManager.getInstance().addTaskToQueueBeginning(new LoadConfigurationFromDiskTask(context));
        if (!((Builder)builder).sdkConfig.isSegmentIntegration) {
            if (TextUtils.isEmpty((CharSequence)builder.appId)) {
                Logger.e("Core_MoEngageinitialise() : App-id not passed. Cannot use MoEngage Platform");
                return;
            }
            ((Builder)builder).sdkConfig.appId = MoEUtils.formatAppId(builder.appId);
        } else {
            Logger.v("Core_MoEngage initialise() : Segment integration enabled will not use app id");
        }
        if (((Builder)builder).sdkConfig.pushConfig.largeIcon == -1) {
            Logger.w("Core_MoEngageinitialise() : Large icon not set");
        }
        if (((Builder)builder).sdkConfig.pushConfig.smallIcon == -1) {
            Logger.w("Core_MoEngage initialise() : Small icon not set will not show notification");
        }
        if (!TextUtils.isEmpty((CharSequence)((Builder)builder).sdkConfig.pushConfig.tone)) {
            String tone = ((Builder)builder).sdkConfig.pushConfig.tone;
            if (tone.contains(".")) {
                tone = tone.substring(0, tone.lastIndexOf("."));
            }
            ((Builder)builder).sdkConfig.pushConfig.tone = tone;
        }
        ArrayList<String> activityNameListInApp = new ArrayList<String>();
        if (builder.inAppOptOutList != null) {
            try {
                for (Class clazz : builder.inAppOptOutList) {
                    activityNameListInApp.add(clazz.getName());
                }
            }
            catch (Exception e) {
                Logger.e("Core_MoEngageinitialise() : Activity Opt out ", e);
            }
        }
        activityNameListInApp.add("com.moengage.pushbase.activities.PushTracker");
        activityNameListInApp.add("com.moengage.pushbase.activities.SnoozeTracker");
        activityNameListInApp.add("com.moengage.integrationverifier.IntegrationVerificationActivity");
        ((Builder)builder).sdkConfig.inAppOptOutList = activityNameListInApp;
        if (builder.activityTrackingOptOutList != null) {
            try {
                ArrayList<String> activityNameList = new ArrayList<String>(builder.activityTrackingOptOutList.size());
                for (Class clazz : builder.activityTrackingOptOutList) {
                    activityNameList.add(clazz.getName());
                }
                ((Builder)builder).sdkConfig.activityTrackingOptOutList = activityNameList;
            }
            catch (Exception e) {
                Logger.e("Core_MoEngageinitialise() : Activity Opt out ", e);
            }
        }
        MoEHelper.getInstance(context).setApplication(builder.application);
        if (builder.application != null && !((Builder)builder).sdkConfig.isSegmentIntegration) {
            MoEHelper.getInstance(context).registerActivityLifecycle(builder.application);
        } else {
            Logger.v("Core_MoEngage initialise() : Segment integration is enabled. Will not register for lifecycle callbacks.");
        }
        SdkConfig.setSdkConfig(builder.sdkConfig);
        if (!((Builder)builder).sdkConfig.isSegmentIntegration) {
            MoEHelper.getInstance(context).registerProcessLifecycleObserver(context);
        }
        try {
            if (!SdkConfig.getConfig().logConfig.isEnabledForSignedBuild) {
                if (!MoEngage.isDebugBuild()) return;
            }
            if (SdkConfig.getConfig().logConfig.level < 5) return;
            Logger.i("Core_MoEngage initialise() : Config: \n" + SdkConfig.getConfig());
            return;
        }
        catch (Exception e) {
            Logger.e("Core_MoEngage initialise() : ", e);
        }
    }

    public static void optOutDataTracking(Context context, boolean shouldOptOutDataTracking) {
        Logger.d("Core_MoEngage optOutDataTracking() : Opt Out Called with value: " + shouldOptOutDataTracking);
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        boolean savedState = provider.isDataTrackingOptedOut();
        provider.optOutOfDataTracking(shouldOptOutDataTracking);
        if (savedState != shouldOptOutDataTracking) {
            MoEDispatcher.getInstance(context).getDeviceAddManager().registerGdprOptOut(context);
        }
        if (shouldOptOutDataTracking) {
            SdkConfig.getConfig().trackingOptOut.setGaidOptedOut(true);
            SdkConfig.getConfig().trackingOptOut.setAndroidIdOptedOut(true);
            SdkConfig.getConfig().isLocationTrackingOptedOut = true;
            SdkConfig.getConfig().isGeofenceTrackingOptedOut = true;
            SdkConfig.getConfig().trackingOptOut.setDeviceAttributeOptedOut(true);
            SdkConfig.getConfig().isLocationServiceEnabled = false;
            TaskManager.getInstance().addTaskToQueue(new DataTrackingOptOutTask(context));
        }
    }

    public static void optOutPushNotification(Context context, boolean shouldOptOutPushNotification) {
        Logger.d("Core_MoEngageoptOutPushNotification: Opt Out Called with value: " + shouldOptOutPushNotification);
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        boolean savedState = provider.isPushNotificationOptedOut();
        provider.optOutOfPushNotification(shouldOptOutPushNotification);
        if (shouldOptOutPushNotification) {
            provider.clearPushToken();
        }
        if (savedState != shouldOptOutPushNotification) {
            MoEDispatcher.getInstance(context).getDeviceAddManager().registerGdprOptOut(context);
        }
    }

    public static void optOutInAppNotification(Context context, boolean shouldOptOutInApp) {
        Logger.d("Core_MoEngage optOutInAppNotification() : Opt out called with value: " + shouldOptOutInApp);
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        boolean savedState = provider.isInAppOptedOut();
        provider.optOutOfInAppNotification(shouldOptOutInApp);
        if (savedState != shouldOptOutInApp) {
            MoEDispatcher.getInstance(context).getDeviceAddManager().registerGdprOptOut(context);
        }
    }

    public static class Builder {
        private String appId;
        private Application application;
        private List<Class> inAppOptOutList;
        private List<Class> activityTrackingOptOutList;
        private SdkConfig sdkConfig;

        public Builder(@NonNull Application application, @NonNull String appId) {
            this.application = application;
            this.appId = appId;
            this.sdkConfig = new SdkConfig();
        }

        public Builder setNotificationLargeIcon(@DrawableRes int largeIcon) {
            this.sdkConfig.pushConfig.largeIcon = largeIcon;
            return this;
        }

        public Builder setNotificationSmallIcon(@DrawableRes int smallIcon) {
            this.sdkConfig.pushConfig.smallIcon = smallIcon;
            return this;
        }

        @Deprecated
        public Builder setSenderId(@NonNull String senderId) {
            this.sdkConfig.pushConfig.fcm.setSenderId(senderId);
            return this;
        }

        public Builder setNotificationColor(@ColorRes int color) {
            this.sdkConfig.pushConfig.notificationColor = color;
            return this;
        }

        public Builder setNotificationTone(String tone) {
            this.sdkConfig.pushConfig.tone = tone;
            return this;
        }

        public Builder enableMultipleNotificationInDrawer() {
            this.sdkConfig.pushConfig.shouldShowMultiplePushInDrawer = true;
            return this;
        }

        public Builder optOutInAppOnActivity(List<Class> inAppOptOutClassList) {
            this.inAppOptOutList = inAppOptOutClassList;
            return this;
        }

        public Builder optOutActivityTracking(List<Class> trackingOptOut) {
            this.activityTrackingOptOutList = trackingOptOut;
            return this;
        }

        public Builder optOutBackStackBuilder() {
            this.sdkConfig.pushConfig.isBackStackBuilderOptedOut = true;
            return this;
        }

        public Builder optOutNavBar() {
            this.sdkConfig.isNavBarOptedOut = true;
            return this;
        }

        @Deprecated
        public Builder optOutGAIDCollection() {
            this.sdkConfig.trackingOptOut.setGaidOptedOut(true);
            return this;
        }

        @Deprecated
        public Builder optOutAndroidIdCollection() {
            this.sdkConfig.trackingOptOut.setAndroidIdOptedOut(true);
            return this;
        }

        public Builder optOutLocationTracking() {
            this.sdkConfig.isLocationTrackingOptedOut = true;
            return this;
        }

        public Builder optOutGeoFence() {
            this.sdkConfig.isGeofenceTrackingOptedOut = true;
            return this;
        }

        @Deprecated
        public Builder optOutCarrierNameCollection() {
            this.sdkConfig.trackingOptOut.setCarrierOptedOut(true);
            return this;
        }

        @Deprecated
        public Builder optOutDeviceAttributeCollection() {
            this.sdkConfig.trackingOptOut.setDeviceAttributeOptedOut(true);
            return this;
        }

        @Deprecated
        public Builder optOutTokenRegistration() {
            this.sdkConfig.pushConfig.fcm.setRegistrationEnabled(false);
            return this;
        }

        @Deprecated
        public Builder redirectDataToRegion(DATA_REGION regionConstant) {
            switch (regionConstant) {
                case REGION_EU: {
                    this.sdkConfig.dataCenter = DataCenter.DATA_CENTER_2;
                    break;
                }
                case REGION_SERV3: {
                    this.sdkConfig.dataCenter = DataCenter.DATA_CENTER_3;
                    break;
                }
                case REGION_DEFAULT: {
                    this.sdkConfig.dataCenter = DataCenter.DATA_CENTER_1;
                }
            }
            return this;
        }

        public Builder setFlushInterval(long interval) {
            this.sdkConfig.flushInterval = interval;
            return this;
        }

        public Builder optOutPeriodicFlush() {
            this.sdkConfig.isPeriodicFlushEnabled = false;
            return this;
        }

        @Deprecated
        public Builder setLogLevel(int logLevel) {
            switch (logLevel) {
                case 1: {
                    this.sdkConfig.logConfig.level = 1;
                    break;
                }
                case 2: {
                    this.sdkConfig.logConfig.level = 2;
                    break;
                }
                case 3: {
                    this.sdkConfig.logConfig.level = 3;
                    break;
                }
                case 4: {
                    this.sdkConfig.logConfig.level = 4;
                    break;
                }
                case 5: {
                    this.sdkConfig.logConfig.level = 5;
                    break;
                }
                default: {
                    this.sdkConfig.logConfig.level = 5;
                }
            }
            return this;
        }

        public Builder enableLogsForSignedBuild() {
            this.sdkConfig.logConfig.isEnabledForSignedBuild = true;
            return this;
        }

        public Builder enableLocationServices() {
            this.sdkConfig.isLocationServiceEnabled = true;
            return this;
        }

        public Builder optOutNotificationLargeIcon() {
            this.sdkConfig.pushConfig.isLargeIconOptedOut = true;
            return this;
        }

        public MoEngage build() {
            return new MoEngage(this);
        }

        public Builder optOutBackgroundSync() {
            this.sdkConfig.isBackgroundSyncEnabled = false;
            return this;
        }

        public Builder optOutRealTimeTriggerBackgroundSync() {
            this.sdkConfig.isRealTimeTriggerBackgroundSyncEnabled = false;
            return this;
        }

        public Builder enableSegmentIntegration() {
            this.sdkConfig.isSegmentIntegration = true;
            return this;
        }

        public Builder optOutDefaultInAppDisplay() {
            this.sdkConfig.isLifecycleInAppOptedOut = true;
            return this;
        }

        @Deprecated
        public Builder setNotificationType(@IntegerRes int notificationType) {
            if (this.application == null) {
                return this;
            }
            int count = this.application.getApplicationContext().getResources().getInteger(notificationType);
            if (count > 1) {
                this.sdkConfig.pushConfig.shouldShowMultiplePushInDrawer = true;
            }
            return this;
        }

        public Builder enableBackgroundLocationFetch() {
            this.sdkConfig.isBackgroundLocationFetchEnabled = true;
            return this;
        }

        public Builder optOutGeofenceBackgroundSync() {
            this.sdkConfig.isGeofenceBackgroundSyncEnabled = false;
            return this;
        }

        public Builder enablePushKitTokenRegistration() {
            this.sdkConfig.pushConfig.isPushKitRegistrationEnabled = true;
            return this;
        }

        @Deprecated
        public Builder setPlaceHolderImageForCard(@DrawableRes int resourceId) {
            this.sdkConfig.cardConfig.cardPlaceHolderImage = resourceId;
            return this;
        }

        @Deprecated
        public Builder setEmptyInboxImageForCard(@DrawableRes int resourceId) {
            this.sdkConfig.cardConfig.inboxEmptyImage = resourceId;
            return this;
        }

        @Deprecated
        public Builder setDateFormatForCard(String dateFormat) {
            this.sdkConfig.cardConfig.cardsDateFormat = dateFormat;
            return this;
        }

        public Builder setTokenRetryInterval(long tokenRetryInterval) {
            if (tokenRetryInterval > 5L) {
                this.sdkConfig.pushConfig.tokenRetryInterval = tokenRetryInterval;
            }
            return this;
        }

        public Builder enableEncryption() {
            this.sdkConfig.isEncryptionEnabled = true;
            return this;
        }

        public Builder configureMiPush(String appId, String appKey, boolean enableTokenRegistration) {
            this.sdkConfig.pushConfig.miPushConfig = new MiPushConfig(appId, appKey, enableTokenRegistration);
            return this;
        }

        public Builder enableLogs(int level) {
            if (LogUtils.isValidLevel(level)) {
                this.sdkConfig.logConfig.level = level;
            }
            return this;
        }

        public Builder setDataCenter(@NonNull DataCenter dataCenter) {
            if (dataCenter != null) {
                this.sdkConfig.dataCenter = dataCenter;
            }
            return this;
        }

        public Builder configureFcm(@NonNull FcmConfig fcmConfig) {
            if (fcmConfig != null) {
                this.sdkConfig.pushConfig.fcm = fcmConfig;
            }
            return this;
        }

        public Builder configureCards(@NonNull CardConfig cardConfig) {
            if (cardConfig != null) {
                this.sdkConfig.cardConfig = cardConfig;
            }
            return this;
        }

        public Builder configureMiPush(@NonNull MiPushConfig miConfig) {
            if (miConfig != null) {
                this.sdkConfig.pushConfig.miPushConfig = miConfig;
            }
            return this;
        }

        public Builder configureTrackingOptOut(@NonNull TrackingOptOutConfig trackingOptOut) {
            if (trackingOptOut != null) {
                this.sdkConfig.trackingOptOut = trackingOptOut;
            }
            return this;
        }
    }

    @Deprecated
    public static enum DATA_REGION {
        REGION_SERV3,
        REGION_EU,
        REGION_DEFAULT;

    }
}

